package de.pfabulist.roast.lang;

import de.pfabulist.roast.functiontypes.BiConsumer_;
import de.pfabulist.roast.functiontypes.Consumer_;
import de.pfabulist.roast.functiontypes.Supplier_;

import javax.annotation.Nullable;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Try_ {
//    public static <A extends AutoCloseable_, B extends AutoCloseable_> void try_OLD( A a, B b, BiConsumer_<A, B> f ) {
//        try {
//            f.accept_( a, b );
//        } finally {
//            a.close_();
//            b.close_();
//        }
//    }

    public static <A extends AutoCloseable_, B extends AutoCloseable_> void try_( Supplier_<A> a, Supplier_<B> b, BiConsumer_<A, B> f ) {

        @Nullable A aa = null;
        @Nullable B bb = null;
        try {
            aa = a.get_();
            bb = b.get_();
            f.accept_( aa, bb );
        } finally {
            if ( aa != null ) {
                aa.close_();
            }

            if ( bb != null ) {
                bb.close_();
            }
        }
    }

    public static <A extends AutoCloseable_> void try_( A a, Consumer_<A> f ) {
        try {
            f.accept_( a );
        } finally {
            a.close_();
        }
    }


}
