package de.pfabulist.roast.math;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Counter {

    public final static Counter ZERO = new Counter( 0 );
    public final static Counter ONE = new Counter( 1 );


    private final long inner;

    public Counter( long nonNegativeNumber ) {
        this.inner = nonNegativeNumber;
        if ( nonNegativeNumber < 0 ) {
            throw new IllegalArgumentException( "argument must be 0 or larger" );
        }
    }

    public long get() {
        return inner;
    }

    public static Counter of( long num ) {
        return new Counter( num );
    }
    public static Counter r_( long num ) {
        return new Counter( num );
    }
}
