package de.pfabulist.roast.nio;

import de.pfabulist.roast.Roast;
import de.pfabulist.roast.lang.AutoCloseable_;

import java.nio.file.DirectoryStream;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface DirectoryStream_<T> extends AutoCloseable_, Roast<DirectoryStream<T>>, Iterable<T>  {

    static <T> DirectoryStream_<T> r_( DirectoryStream<T> other ) {
        if ( other instanceof DirectoryStream_ ) {
            return (DirectoryStream_<T>) other;
        }

        return new DirectoryStream_of<T>( other );
    }
}
