package de.pfabulist.roast.nio;

import java.nio.file.DirectoryStream;
import java.util.Iterator;

import static de.pfabulist.roast.functiontypes.Runnable_.v_;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class DirectoryStream_of<T> implements DirectoryStream_<T> {

    private final DirectoryStream<T> inner;

    public DirectoryStream_of( DirectoryStream<T> other ) {
        inner = other;
    }

    @Override
    public DirectoryStream<T> _r() {
        return inner;
    }

    @Override
    public void close_() {
        v_( inner::close );
    }

    @Override
    public Iterator<T> iterator() {
        return inner.iterator();
    }

//    @Override
//    public void forEach( Consumer<? super T> action ) {
//
//    }
//
//    @Override
//    public Spliterator<T> spliterator() {
//        return null;
//    }
}
