package de.pfabulist.roast.nio;

import de.pfabulist.roast.Roast;
import de.pfabulist.roast.lang.AutoCloseable_;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;

import static de.pfabulist.roast.functiontypes.Supplier_.vn_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface FileChannel_ extends AutoCloseable_,  Roast<FileChannel> {

    static FileChannel_ r_( FileChannel fileChannel ) {
        if( fileChannel instanceof FileChannel_ ) {
            return (FileChannel_) fileChannel;
        }
        return new FileChannel_of( fileChannel );
    }

    static FileChannel open_( Path path, OpenOption... options ) {
        return vn_( () -> FileChannel.open( path, options ));
    }

    static FileChannel open_( Path path, Set<? extends OpenOption> options, FileAttribute<?>... attrs ) {
        return vn_( () -> FileChannel.open( path, options, attrs ));
    }

    static FileChannel_ open__( Path path, Set<? extends OpenOption> options, FileAttribute<?>... attrs ) {
        return FileChannel_.r_( open_( path, options, attrs ) );
    }

    long position_();
    FileChannel position_( long newPosition );

    int read_( ByteBuffer dst );
    long read_( ByteBuffer[] dsts, int offset, int length );

    long read_( ByteBuffer[] dsts );

    long size_();


//    public void close() {
//        try {
//            inner.close();
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
//
//    public long transferFrom( SeekableByteChannell ch, int position_, int count ) {
//        try {
//            return inner.transferFrom( ch._r(), position_, count );
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
    long transferFrom_( ReadableByteChannel src, long position, long count);

    long transferTo_( long position, long count, WritableByteChannel target);


//
//    public long position_() {
//        try {
//            return inner.position_();
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
//
//    public FileChannel_ position_( int newpos ) {
//        try {
//            inner.position_( newpos );
//            return this;
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
//
//    public int read( ByteBuffer bb ) {
//        try {
//            return inner.read( bb );
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
//
//    public long read( ByteBuffer[] bb ) {
//        try {
//            return inner.read( bb );
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
//

    void force_( boolean b );

    FileLock lock_();

//
//    @Override
//    public FileChannel _r() {
//        return inner;
//    }


}
