package de.pfabulist.roast.nio;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;

import static de.pfabulist.roast.functiontypes.Supplier_.vn_;
import static de.pfabulist.roast.functiontypes.Runnable_.v_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class FileChannel_of implements FileChannel_ {
    private final FileChannel inner;

    public FileChannel_of( FileChannel fileChannel ) {
        inner = fileChannel;
    }

    @Override
    public FileChannel _r() {
        return inner;
    }

    @Override
    public long position_() {
        return vn_( () -> inner.position());
    }

    @Override
    public FileChannel position_( long newPosition )  {
        return vn_( () -> inner.position( newPosition ));
    }

    @Override
    public int read_( ByteBuffer dst ) {
        return vn_( () ->inner.read( dst ));
    }

    @Override
    public long read_( ByteBuffer[] dsts, int offset, int length ) {
        return vn_( () ->inner.read( dsts, offset, length ));
    }

    @Override
    public long read_( ByteBuffer[] dsts ) {
        return read_( dsts, 0, dsts.length );
    }

    @Override
    public long size_() {
        return vn_( inner::size );
    }

    @Override
    public long transferFrom_( ReadableByteChannel src, long position, long count ) {
        return vn_( () -> inner.transferFrom( src, position, count ));
    }

    @Override
    public long transferTo_(long position, long count,
                            WritableByteChannel target) {
        return vn_( () -> inner.transferTo( position, count, target ));
    }

    @Override
    public void force_( boolean b ) {
        v_( () -> inner.force( b ));
    }

    @Override
    public FileLock lock_() {
        return vn_( inner::lock );
    }

    @Override
    public void close_() {
        v_( inner::close );
    }



}
