package de.pfabulist.roast.nio;

import de.pfabulist.roast.Roast;
import de.pfabulist.roast.collection.Map_;

import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface FileSystemProvider_ extends Roast<FileSystemProvider> {

    static FileSystemProvider_ r_( FileSystemProvider provider ) {
        if( provider instanceof FileSystemProvider_ ) {
            return (FileSystemProvider_) provider;
        }
        return new FileSystemProvider_of( provider );
    }

    // readAttributes -----------------------

    <A extends BasicFileAttributes> A readAttributes_( Path path, Class<A> type, LinkOption... options );

    Map<String,Object> readAttributes_(Path path, String attributes, LinkOption... options);

//    default Map<String,Object> readAttributes( @Nullable Path path, @Nullable String attributes, LinkOption... options) {
//        return readAttributes_( n_(path), n_( attributes ), options );
//    }

    default Map_<String,Object> readAttributes__(Path path, String attributes, LinkOption... options) {
        return Map_.r_( readAttributes_( path, attributes, options ) );
    }

    // newByteChannel -----------------------

//    default  @Nullable SeekableByteChannel newByteChannel( @Nullable Path path, @Nullable Set<? extends OpenOption> options, @Nullable FileAttribute<?>... attrs  ) {
//        return newByteChannel_( n_(path), n_(options),n_(attrs ));
//    }

    SeekableByteChannel newByteChannel_( Path path, Set<? extends OpenOption> options, FileAttribute<?>... attrs );

    default SeekableByteChannel_ newByteChannel__( Path path, Set<? extends OpenOption> options, FileAttribute<?>... attrs  ) {
        return SeekableByteChannel_.r_( newByteChannel_( path, options, attrs ));
    }

    // copy -----------------------------

//    default void copy( @Nullable Path src, @Nullable Path tgt, CopyOption ... options ) {
//        copy_( n_(src), n_(tgt), options );
//    }

    void copy_( Path src, Path tgt, CopyOption ... options );

    // move -----------------------------

//    default void move( @Nullable Path src, @Nullable Path tgt, CopyOption ... options ) {
//        move_( n_(src), n_(tgt), options );
//    }

    void move_( Path src, Path tgt, CopyOption ... options );

    // getScheme --------------------------------

    String getScheme();

    // newFileSystem --------------------------

    FileSystem newFileSystem_( URI uri, Map<String,?> env );

    // getFileSystem_ --

    FileSystem getFileSystem_( URI uri );

    // getFileAttributeView

    <V extends FileAttributeView> Optional<V> getFileAttributeView_o( Path path, Class<V> type, LinkOption... options);

    default <V extends FileAttributeView> V getFileAttributeView_ot( Path path, Class<V> type, LinkOption... options) {
        return getFileAttributeView_o( path, type, options ).orElseThrow( () -> new IllegalArgumentException( "no such view " + type ) );
    }

//    default <V extends FileAttributeView> Optional<V> getFileAttributeView_o( @Nullable Path path, @Nullable Class<V> type, LinkOption... options) {
//        return getFileAttributeView_o( n_(path), n_(type ), options );
//    }


    // setAttribute

//    default void setAttribute( @Nullable Path path, @Nullable String attribute, @Nullable Object value, LinkOption... options ) {
//        setAttribute_( n_(path), n_(attribute), n_(value), options );
//    }

    void setAttribute_( Path path, String attribute, Object value, LinkOption... options );

    // isSameFile -------------------

//    default boolean isSameFile( @Nullable Path path, @Nullable Path file ) {
//        return isSameFile_( n_( path), n_( file ));
//    }

    boolean isSameFile_( Path path, Path file );

    // checkAccess ---------------------

//    default void checkAccess( @Nullable Path file, AccessMode ... modes ) {
//        checkAccess_( n_(file), modes );
//    }

    void checkAccess_( Path file, AccessMode ... modes );

    // createDirectory ---------------------

//    default void createDirectory( @Nullable Path path, FileAttribute<?>... attrs ) {
//        createDirectory_( n_(path), attrs );
//    }

    void createDirectory_( Path dir, FileAttribute<?>... attrs );

    // delete

//    default void delete( @Nullable Path path ) {
//        delete_( n_(path) );
//    }

    void delete_( Path path );

//    default boolean deleteIfExists( @Nullable Path path ) {
//        return deleteIfExists_( n_(path) );
//    }

    boolean deleteIfExists_( Path path );

    FileStore getFileStore_( Path file );

    DirectoryStream<Path> newDirectoryStream_( Path dir, DirectoryStream.Filter<? super Path> filter);

    FileChannel newFileChannel_( Path path, Set<? extends OpenOption> options, FileAttribute<?>... attrs);

    void createSymbolicLink_( Path linkArg, Path target, FileAttribute<?>... attrs );

    void createLink_( Path linkArg, Path existingArg );

    Path readSymbolicLink_( Path linkArg );
}
