package de.pfabulist.roast.nio;


import javax.annotation.Nullable;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import static de.pfabulist.roast.NonnullCheck.n_;
import static de.pfabulist.roast.functiontypes.Supplier_.vn_;
import static de.pfabulist.roast.functiontypes.Runnable_.v_;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class FileSystemProvider_of implements FileSystemProvider_ {

    private final FileSystemProvider inner;

    public FileSystemProvider_of( FileSystemProvider fileSystem ) {
        inner = fileSystem;
    }

//    public String getSeparator() {
//        return _nn( inner.getSeparator() );
//    }

//    public @Nullable Path getPath( @Nullable String first, String... more ) {
//        return inner.getPath( first, more );
//    }

//    public Iterable<Pathh> getRootDirectories() {
//
//        final Iterable<Path> innnerIt = _nn( inner.getRootDirectories() );
//
//        return () -> new Iterator<Pathh>() {
//
//            Iterator<Path> it = _nn( innnerIt.iterator() );
//
//            @Override
//            public boolean hasNext() {
//                return it.hasNext();
//            }
//
//            @Override
//            public Pathh next() {
//                return Pathh.r_( _nn( it.next() ) );
//            }
//        };
//
//    }

//    public @Nullable PathMatcher getPathMatcher( @Nullable String pat ) {
//        return inner.getPathMatcher( pat );
//    }
//
//    public Set<String> supportedFileAttributeViews() {
//        return _nn( inner.supportedFileAttributeViews() );
//    }
//
//    public FileSystemProvider_ provider() {
//        return FileSystemProvider_.r_( _nn( inner.provider() ) );
//    }
//
//    public UserPrincipalLookupServicee getUserPrincipalLookupService() {
//        return UserPrincipalLookupServicee.r_( _nn( inner.getUserPrincipalLookupService() ) );
//    }
//
//    public boolean isOpen_() {
//        return inner.isOpen_();
//    }
//
//    public WatchServicee newWatchService_() {
//        try {
//            return WatchServicee.r_( _nn( inner.newWatchService_() ) );
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//    }
//
//    public void close() {
//        try {
//            inner.close();
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//    }

    @Override
    public boolean equals( @Nullable Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;

        FileSystemProvider_of that = (FileSystemProvider_of) o;

        return inner.equals( that.inner );

    }

    @Override
    public int hashCode() {
        return inner.hashCode();
    }

//    public Iterable<FileStoree> getFileStores() {
//        return () -> new Iterator<FileStoree>() {
//            Iterator<FileStore> it = _nn(_nn( inner.getFileStores()).iterator());
//
//            @Override
//            public boolean hasNext() {
//                return it.hasNext();
//            }
//
//            @Override
//            public FileStoree next() {
//                return FileStoree.r_( _nn(it.next() ));
//            }
//        };
//    }

//    public boolean isReadOnly() {
//        return inner.isReadOnly();
//    }

//    @Override
//    public FileSystem _r() {
//        return inner;
//    }

//    @Override
//    public @Nullable String getScheme() {
//        return inner.getScheme();
//    }
//
//    @Override
//    public @Nullable FileSystem newFileSystem_( @Nullable URI uri, @Nullable Map<String, ?> env ) throws IOException {
//        return inner.newFileSystem_( uri, env );
//    }
//
//    @Override
//    public @Nullable FileSystem getFileSystem_( @Nullable URI uri ) {
//        return inner.getFileSystem_( uri );
//    }
//
//    @Override
//    public @Nullable Path getPath( @Nullable URI uri ) {
//        return inner.getPath( uri );
//    }
//
//    @Override
//    public @Nullable SeekableByteChannel newByteChannel( @Nullable Path path, @Nullable Set<? extends OpenOption> options, @Nullable FileAttribute<?>[] attrs ) throws IOException {
//        return inner.newByteChannel( path, options, attrs );
//    }
//
//    @Override
//    public @Nullable DirectoryStream<Path> newDirectoryStream( @Nullable Path dir, @Nullable DirectoryStream.Filter<? super Path> filter ) throws IOException {
//        return inner.newDirectoryStream( dir, filter );
//    }
//
//    @Override
//    public void createDirectory( @Nullable Path dir, @Nullable FileAttribute<?>[] attrs ) throws IOException {
//        inner.createDirectory( dir, attrs );
//    }
//
//    @Override
//    public void delete( @Nullable Path path ) throws IOException {
//        inner.delete( path );
//    }
//
//    @Override
//    public void copy( @Nullable Path source, @Nullable Path target, CopyOption... options ) throws IOException {
//        inner.copy( source, target, options );
//    }
//
//    @Override
//    public void move( @Nullable Path source, @Nullable Path target, CopyOption... options ) throws IOException {
//        inner.move( source, target, options );
//    }
//
//    @Override
//    public boolean isSameFile( @Nullable Path path, @Nullable Path path2 ) throws IOException {
//        return inner.isSameFile( path, path2 );
//    }
//
//    @Override
//    public boolean isHidden( @Nullable Path path ) throws IOException {
//        return inner.isHidden( path );
//    }
//
//    @Override
//    public @Nullable FileStore getFileStore( @Nullable Path path ) throws IOException {
//        return inner.getFileStore( path );
//    }
//
//    @Override
//    public void checkAccess( @Nullable Path path, AccessMode... modes ) throws IOException {
//        inner.checkAccess( path, modes );
//    }
//
//    @Override
//    public @Nullable <V extends FileAttributeView>  V getFileAttributeView( @Nullable Path path, @Nullable Class<V> type, LinkOption... options ) {
//        return inner.getFileAttributeView( path, type, options );
//    }
//
//    @Override
//    public @Nullable<A extends BasicFileAttributes> A readAttributes( @Nullable Path path, @Nullable Class<A> type, @Nullable LinkOption... options ) throws IOException {
//        return inner.readAttributes( path, type, options );
//    }
//
//    @Override
//    public @Nullable Map<String, Object> readAttributes( @Nullable Path path, @Nullable String attributes, @Nullable LinkOption... options ) throws IOException {
//        return inner.readAttributes( path, attributes, options );
//    }
//
//    @Override
//    public void setAttribute( @Nullable Path path, @Nullable String attribute, @Nullable Object value, @Nullable LinkOption... options ) throws IOException {
//        inner.setAttribute( path, attribute, value, options );
//    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes_( Path path, Class<A> type, LinkOption... options ) {
        return vn_( () -> n_( inner.readAttributes( path, type, options )));
    }

    @Override
    public Map<String,Object> readAttributes_(Path path, String attributes, LinkOption... options) {
        return vn_( () -> n_( inner.readAttributes( path, attributes, options )));
    }


    @Override
    public SeekableByteChannel newByteChannel_( Path path, Set<? extends OpenOption> options, FileAttribute<?>... attrs ) {
        return vn_( () -> n_( inner.newByteChannel( path, options, attrs )));
    }

    @Override
    public void copy_( Path src, Path tgt, CopyOption ... options ) {
        v_( () -> inner.copy( src, tgt, options ));
    }

    @Override
    public void move_( Path src, Path tgt, CopyOption... options ) {
        v_( () -> inner.move( src, tgt, options ));
    }

    @Override
    public String getScheme() {
        return n_( inner.getScheme());
    }

    @Override
    public FileSystem newFileSystem_( URI uri, Map<String,?> env ) {
        return vn_( () -> n_( inner.newFileSystem( uri, env )));
    }

    @Override
    public FileSystem getFileSystem_( URI uri ) {
        return vn_( () -> n_( inner.getFileSystem( uri )));
    }

    @Override
    public <V extends FileAttributeView> Optional<V> getFileAttributeView_o( Path path, Class<V> type, LinkOption... options) {
        return vn_( () -> Optional.ofNullable( inner.getFileAttributeView( path, type, options )));
    }

    @Override
    public void setAttribute_( Path path, String attribute, Object value, LinkOption... options ) {
        v_( () -> inner.setAttribute( path, attribute, value, options ));
    }

    @Override
    public boolean isSameFile_( Path a, Path b ) {
        return vn_( () -> inner.isSameFile( a, b ));
    }

    @Override
    public void checkAccess_( Path file, AccessMode ... modes ) {
        v_( () -> inner.checkAccess( file, modes ));
    }

    @Override
    public void createDirectory_( Path dir, FileAttribute<?>... attrs ) {
        v_( () -> inner.createDirectory( dir, attrs ));
    }

    @Override
    public void delete_( Path path ) {
        v_( () -> inner.delete( path ));
    }

    @Override
    public boolean deleteIfExists_( Path path ) {
        return vn_( () -> inner.deleteIfExists( path ));
    }

    @Override
    public FileStore getFileStore_( Path file ) {
        return vn_( () -> n_( inner.getFileStore( file )));
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream_( Path dir, DirectoryStream.Filter<? super Path> filter ) {
        return vn_( () -> inner.newDirectoryStream( dir, filter ));
    }

    @Override
    public FileChannel newFileChannel_( Path path, Set<? extends OpenOption> options, FileAttribute<?>... attrs) {
        return vn_( () -> inner.newFileChannel( path, options, attrs ));
    }

    @Override
    public void createSymbolicLink_( Path linkArg, Path target, FileAttribute<?> ... attrs ) {
        v_( () -> inner.createSymbolicLink( linkArg, target, attrs ));
    }

    @Override
    public void createLink_( Path linkArg, Path existingArg ) {
        v_( () -> inner.createLink( linkArg, existingArg ));
    }

    @Override
    public Path readSymbolicLink_( Path linkArg ) {
        return vn_( () -> inner.readSymbolicLink( linkArg ));
    }

    @Override
    public FileSystemProvider _r() {
        return inner;
    }
}
