package de.pfabulist.roast.nio;

import de.pfabulist.roast.Roast;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface FileSystem_ extends Roast<FileSystem> {

    static FileSystem_ r_( FileSystem fileSystem ) {
        if ( fileSystem instanceof FileSystem_ ) {
            return (FileSystem_) fileSystem;
        }
        return new FileSystem_of( fileSystem );
    }

    // provider -------

//    default FileSystemProvider provider() {
//        return provider_();
//    }

    FileSystemProvider provider_();

    default FileSystemProvider_ provider__() {
        return FileSystemProvider_.r_( provider_() );
    }


    // getPath --------------------

//    default Path getPath( @Nullable String name, @Nullable String ... next ) {
//        return getPath_( n_( name ), n_( next ));
//    }

    Path getPath_( String name, String ... next );

    default Path_ getPath__( String name, String ... next ) {
        return Path_.r_( getPath_( name, next ));
    }

    // getPathMatcher --------------------

//    default @Nullable PathMatcher getPathMatcher( @Nullable String syntaxAndPattern ) {
//        return getPathMatcher_( n_( syntaxAndPattern ));
//    }

    PathMatcher getPathMatcher_( String syntaxAndPattern );

    void close();

    WatchService newWatchService_();

    UserPrincipalLookupService getUserPrincipalLookupService_();

    default UserPrincipalLookupService_ getUserPrincipalLookupService__() {
        return UserPrincipalLookupService_.r_( getUserPrincipalLookupService_() );
    }

//    public Iterable<Path_> getRootDirectories_();

}
