package de.pfabulist.roast.nio;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;

import static de.pfabulist.roast.NonnullCheck.n_;
import static de.pfabulist.roast.functiontypes.Supplier_.vn_;
import static de.pfabulist.roast.functiontypes.Runnable_.v_;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class FileSystem_of implements FileSystem_ {

    private final FileSystem inner;

    public FileSystem_of( FileSystem inner ) {
        this.inner = inner;
    }


//    @Override
//    public void close() throws IOException {
//        inner.close();
//    }
//
//    @Override
//    public boolean isOpen_() {
//        return inner.isOpen_();
//    }
//
//    @Override
//    public boolean isReadOnly() {
//        return inner.isReadOnly();
//    }
//
//    @Override
//    public @Nullable String getSeparator() {
//        return inner.getSeparator();
//    }
//
//    @Override
//    public @Nullable Iterable<Path> getRootDirectories() {
//        return inner.getRootDirectories();
//    }
//
//    @Override
//    public @Nullable Iterable<FileStore> getFileStores() {
//        return inner.getFileStores();
//    }
//
//    @Override
//    public @Nullable Set<String> supportedFileAttributeViews() {
//        return inner.supportedFileAttributeViews();
//    }


//    @Override
//    public @Nullable UserPrincipalLookupService getUserPrincipalLookupService() {
//        return inner.getUserPrincipalLookupService();
//    }

//    @Override
//    public @Nullable WatchService newWatchService_() throws IOException {
//        return inner.newWatchService_();
//    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;

        FileSystem_of that = (FileSystem_of) o;

        return inner.equals( that.inner );
    }

    @Override
    public int hashCode() {
        return inner.hashCode();
    }

    @Override
    public FileSystem _r() {
        return inner;
    }

    @Override
    public FileSystemProvider provider_() {
        return n_( inner.provider());
    }

    @Override
    public Path getPath_( String name, String... next ) {
        return n_( inner.getPath( name, next ));
    }

    @Override
    public PathMatcher getPathMatcher_( String syntaxAndPattern ) {
        return n_( inner.getPathMatcher( syntaxAndPattern ));
    }

    @Override
    public void close() {
        v_( inner::close );
    }

    @Override
    public WatchService newWatchService_() {
        return vn_( () -> n_( inner.newWatchService()));
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService_() {
        return n_( inner.getUserPrincipalLookupService());
    }
}
