package de.pfabulist.roast.nio;

import de.pfabulist.roast.Roast;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Optional;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface Path_ extends Roast<Path> {
    // not extends Path (because r_ easy error)
    // no default impl r_ Path methods (because problems when writing A extends Path_, Path)

    static Path_ r_( Path path ) {
        if( path instanceof Path_ ) {
            return (Path_) path;
        }
        return new Path_of( path );
    }

    // getName -------------------

//    default
//    @Nullable
//    Path getName( int i ) {
//        return getName_( i );
//    }

    Path getName_( int i );

    default Path_ getName__( int i ) {
        return Path_.r_( getName_( i ) );
    }

    // getNameCount ---------------

//    default int getNameCount() {
//        return getNameCount_();
//    }

    int getNameCount_();

    // toAbsolutePathh ---------------------

//    default
//    @Nullable
//    Path toAbsolutePath() {
//        return toAbsolutePath_();
//    }

    Path toAbsolutePath_();

    default Path_ toAbsolutePath__() {
        return Path_.r_( toAbsolutePath_() );
    }

    // getRoot may legitimately return null ---------------------------

//    default
//    @Nullable
//    Path getRoot() {
//        return getRoot_o().get_();
//    }

    Optional<Path> getRoot_o();

    default Path getRoot_ot() {
        return getRoot_o().orElseThrow( () -> new IllegalArgumentException( "path has no root" ) );
    }

    default Path_ getRoot__ot() {
        return Path_.r_( getRoot_ot() );
    }

    // resolve str should never return null ---------------------------------

//    default
//    @Nullable
//    Path resolve( @Nullable String other ) {
//        return resolve_( n_( other ) );
//    }

    Path resolve_( String other );

    default Path_ resolve__( String other ) {
        return Path_.r_( resolve_( other ) );
    }

    // resolve path should never return null ---------------------------------

//    default
//    @Nullable
//    Path resolve( @Nullable Path other ) {
//        return resolve_( n_( other ) );
//    }

    Path resolve_( Path other );

    default Path_ resolve__( Path other ) {
        return Path_.r_( resolve_( other ) );
    }

    // isAbsolute_ ------------------------------

//    default boolean isAbsolute() {
//        return isAbsolute_();
//    }

    boolean isAbsolute_();

    // getFileSystem ---------------------------------

//    default
//    @Nullable
//    FileSystem getFileSystem() {
//        return getFileSystem_();
//    }

    FileSystem getFileSystem_();

    default FileSystem_ getFileSystem__() {
        return FileSystem_.r_( getFileSystem_() );
    }

    // endsWith path----------------------------------------

//    default boolean endsWith( @Nullable Path path ) {
//        return endsWith_( n_( path ) );
//    }

    boolean endsWith_( Path path );

    // endsWith string ----------------------------------------

//    default boolean endsWith( @Nullable String str ) {
//        return endsWith_( n_( str ) );
//    }

    boolean endsWith_( String str );

    // startsWith str ----------------------------------------

//    default boolean startsWith( @Nullable String str ) {
//        return startsWith_( n_( str ) );
//    }

    boolean startsWith_( String str );

    // startsWith path ----------------------------------------

//    default boolean startsWith( @Nullable Path path ) {
//        return startsWith_( n_( path ) );
//    }

    boolean startsWith_( Path path );

    // subpath__ ---------------------------

//    default
//    @Nullable
//    Path subpath( int from, int to ) {
//        return subpath_( from, to );
//    }

    Path subpath_( int from, int to );

    default Path_ subpath__( int from, int to ) {
        return Path_.r_( subpath_( from, to ) );
    }

    // getFileName -----------------------

//    default
//    @Nullable
//    Path getFileName() {
//        return getFileName_o().get_();
//    }

    Optional<Path> getFileName_o();

    default Path getFileName_ot() {
        return getFileName_o().orElseThrow( () -> new IllegalArgumentException( "path has no filename" ) );
    }

    // relativize -----------------------

//    default
//    @Nullable
//    Path relativize( @Nullable Path other ) {
//        return relativize_( n_( other ) );
//    }

    Path relativize_( Path other );

    default Path_ relativize__( Path other ) {
        return Path_.r_( relativize_( other ) );
    }

    // getParent -----------------------

//    default
//    @Nullable
//    Path getParent() {
//        return getParent_o().get_();
//    }

    Optional<Path> getParent_o();

    default Path getParent_ot() {
        return getParent_o().orElseThrow( () -> new IllegalArgumentException( "path has no parent" ) );
    }

    default Path_ getParent__ot() {
        return Path_.r_( getParent_ot() );
    }

    // normalize ------------------------------

//    default
//    @Nullable
//    Path normalize() {
//        return normalize_();
//    }

    Path normalize_();

    default Path_ normalize__() {
        return Path_.r_( normalize_() );
    }

    // toURI

//    @Override
//    default
//    @Nullable
//    URI toUri() {
//        return toUri_();
//    }

    URI toUri_();

    // toRealPath_ ---------------------------

//    @Override
//    default
//    @Nullable
//    Path toRealPath( LinkOption... options ) {
//        return toRealPath_( n_( options ) );
//    }

    Path toRealPath_( LinkOption... options );

    // register -----------------

//    @Override
//    default
//    @Nullable
//    WatchKey register( @Nullable WatchService ws, WatchEvent.Kind<?>... kinds ) {
//        return register_( n_( ws ), n_( kinds ) );
//    }

    WatchKey register_( WatchService ws, WatchEvent.Kind<?>... kinds );

    // ----

//    @Override
//    default
//    @Nullable
//    Iterator<Path> iterator() {
//        return iterator_();
//    }

    Iterator<Path> iterator_();

    // ----

//    @Override
//    default
//    @Nullable
//    Path resolveSibling( @Nullable Path other ) {
//        return resolveSibling_( n_( other ) );
//    }

    Path resolveSibling_( Path other );

    // ----

//    @Override
//    default
//    @Nullable
//    Path resolveSibling( @Nullable String other ) {
//        return resolveSibling_( n_( other ) );
//    }

    Path resolveSibling_( String other );

    // ----

//    @Override
//    default
//    @Nullable
//    File toFile() {
//        return toFile_();
//    }

    File toFile_();

    // ---

//    @Override
//    default
//    @Nullable
//    WatchKey register( @Nullable WatchService watcher, @Nullable WatchEvent.Kind<?>[] events, WatchEvent.Modifier... modifiers ) throws IOException {
//        return register_( n_( watcher ), n_( events ), n_( modifiers ) );
//    }

    WatchKey register_( WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier... modifiers );

    int hashCode_();

    // ---

//    @Override
//    default int compareTo( @Nullable Path other ) {
//        return compareTo_( n_( other ) );
//    }

//    int compareTo_( Path other );

}