package de.pfabulist.roast.nio;

import de.pfabulist.roast.functiontypes.Supplier_;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Optional;

import static de.pfabulist.roast.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Path_of implements Path_ {

    private final Path real;

    public Path_of( Path real ) {
        this.real = real;
    }


    @Override
    public Path _r() {
        return real;
    }

    public static Path unwrap( Path path ) {
        if( path instanceof Path_ ) {
            return ( (Path_) path )._r();
        }

        return path;
    }


    @Override
    public Path getName_( int i ) {
        return n_( real.getName( i ) );
    }

    @Override
    public int getNameCount_() {
        return real.getNameCount();
    }


    @Override
    public Path toAbsolutePath_() {
        return n_( real.toAbsolutePath() );
    }


    @Override
    public Optional<Path> getRoot_o() {
        return Optional.ofNullable( real.getRoot() );
    }

    @Override
    public Path resolve_( String other ) {
        return n_( real.resolve( other ) );
    }

    @Override
    public Path resolve_( Path other ) {
        return n_( real.resolve( other ) );
    }

    @Override
    public boolean isAbsolute_() {
        return real.isAbsolute();
    }

    @Override
    public FileSystem getFileSystem_() {
        return n_( real.getFileSystem() );
    }

    @Override
    public boolean endsWith_( Path path ) {
        return real.endsWith( path );
    }

    @Override
    public boolean endsWith_( String str ) {
        return real.endsWith( str );
    }

    @Override
    public boolean startsWith_( String str ) {
        return real.startsWith( str );
    }

    @Override
    public boolean startsWith_( Path path ) {
        return real.startsWith( path );
    }

    @Override
    public Path subpath_( int from, int to ) {
        return n_( real.subpath( from, to ) );
    }

    @Override
    public Optional<Path> getFileName_o() {
        return Optional.ofNullable( real.getFileName() );
    }

    @Override
    public Path relativize_( Path other ) {
        return n_( real.relativize( other ) );
    }

    @Override
    public Optional<Path> getParent_o() {
        return Optional.ofNullable( real.getParent() );
    }

    @Override
    public Path normalize_() {
        return n_( real.normalize() );
    }

    @Override
    public URI toUri_() {
        return n_( real.toUri() );
    }

    @Override
    public Path toRealPath_( LinkOption ... options ) {
        return Supplier_.vn_( () -> n_( real.toRealPath( options )));
    }

    @Override
    public final WatchKey register_( WatchService ws, WatchEvent.Kind<?>... kinds ) {
        return Supplier_.vn_( () -> n_( real.register( ws, kinds )));
    }

    @Override
    public Iterator<Path> iterator_() {
        return n_(real.iterator());
    }

    @Override
    public Path resolveSibling_( Path other ) {
        return n_( real.resolveSibling( other ));
    }

    @Override
    public Path resolveSibling_( String other ) {
        return n_( real.resolveSibling( other ));
    }

    @Override
    public File toFile_() {
        return n_(real.toFile());
    }

    @Override
    public WatchKey register_( WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier... modifiers ) {
        return Supplier_.vn_( () -> n_( real.register( watcher, events, modifiers )));
    }

    @Override
    public int hashCode_() {
        return real.hashCode();
    }

//    @Override
//    public int compareTo_( Path other ) {
//        return real.compareTo( other );
//    }
}
