//package de.pfabulist.roast.nio;
//
//import javax.annotation.Nullable;
//import java.io.File;
//import java.io.IOException;
//import java.net.URI;
//import java.nio.file.LinkOption;
//import java.nio.file.Path;
//import java.nio.file.WatchEvent;
//import java.nio.file.WatchKey;
//import java.util.Iterator;
//import java.util.Optional;
//
//import static de.pfabulist.roast.NonnullCheck._nn;
//import static de.pfabulist.roast.NonnullCheck._orElseThrow;
//import static de.pfabulist.roast.unchecked.Unchecked.en__;
//
///**
// * Copyright (c) 2006 - 2016, Stephan Pfab
// * SPDX-License-Identifier: BSD-2-Clause
// */
//
//public class PathhFromPath implements Pathh {
//
//    public static PathhFromPath r_( Path path ) {
//        return new PathhFromPath( path );
//    }
//
//    private final Path inner;
//
//    public PathhFromPath( Path inner ) {
//        this.inner = inner;
//    }
//
//    @Override
//    public PathhFromPath resolve( String str ) {
//        return PathhFromPath.r_( _nn( inner.resolve( str ) ) );
//    }
//
//    @Override
//    public Optional<Pathh> getParent() {
//        return inner.getParent() == null ? Optional.empty() : Optional.r_( PathhFromPath.r_( _nn( inner.getParent() ) ) );
//    }
//
//    @Override
//    public Pathh getParent_ot() {
//        return getParent().orElseThrow( () -> new IllegalArgumentException( "path has no parent" ) );
//    }
//
//    @Override
//    public Path _r() {
//        return inner;
//    }
//
//    @Override
//    public Pathh getName( int i ) {
//        return PathhFromPath.r_( _orElseThrow( inner.getName( i ), () -> new IllegalStateException( "programming error: name(i) r_ path is null" ) ) );
//    }
//
//    @Override
//    public String toString() {
//        return _orElseThrow( inner.toString(), () -> new IllegalStateException( "programming error: toString r_ path is null" ) );
//    }
//
//    @Override
//    public int getNameCount() {
//        return inner.getNameCount();
//    }
//
//    @Override
//    public boolean isAbsolute_() {
//        return inner.isAbsolute_();
//    }
//
//    @Override
//    public boolean endsWith( Pathh with ) {
//        testType( with );
//        return inner.endsWith( ((PathhFromPath)with).inner );
//    }
//
//    @Override
//    public boolean endsWith( String with ) {
//        return inner.endsWith( with );
//    }
//
//    @Override
//    public boolean startsWith( Pathh bc ) {
//        testType( bc );
//        return inner.startsWith( ((PathhFromPath)bc).inner );
//    }
//
//    @Override
//    public boolean startsWith( String with ) {
//        return inner.startsWith( with );
//    }
//
//    @Override
//    public Pathh subpath( int from, int to ) {
//        return PathhFromPath.r_( _nn( inner.subpath( from, to ) ) );
//    }
//
//    @Override
//    public boolean isRelative() {
//        return !inner.isAbsolute_();
//    }
//
//    @Override
//    public Optional<Pathh> getFileName() {
//        return Optional.ofNullable( inner.getFileName() ).map( PathhFromPath::r_ );
//    }
//
//    @Override
//    public Pathh getFileName_ot() {
//        return getFileName().orElseThrow( () -> new IllegalArgumentException( "path has no elements" ) );
//    }
//
//    @Override
//    public Pathh resolve( Pathh pathh ) {
//        testType( pathh );
//        return PathhFromPath.r_( _nn( inner.resolve( ((PathhFromPath)pathh).inner ) ) );
//    }
//
//    @Override
//    public FileSystem_ getFileSystem_() {
//        return FileSystem_.r_( _nn( inner.getFileSystem_() ) );
//    }
//
//    @Override
//    public Pathh resolveSibling( Pathh other ) {
//        testType( other );
//        return PathhFromPath.r_( _nn( inner.resolveSibling( ((PathhFromPath)other).inner ) ) );
//    }
//
//    @Override
//    public Pathh resolveSibling( String other ) {
//        return PathhFromPath.r_( _nn( inner.resolveSibling( other ) ) );
//    }
//
//    @Override
//    public Pathh relativize( Pathh other ) {
//        testType( other );
//        return PathhFromPath.r_( _nn( inner.relativize( ((PathhFromPath)other).inner ) ) );
//    }
//
//    @Override
//    public Pathh toAbsolutePathh() {
//        return PathhFromPath.r_( _nn( inner.toAbsolutePath() ) );
//    }
//
//    public PathhFromPath normalize() {
//        return PathhFromPath.r_( _nn( inner.normalize() ) );
//    }
//
//    @Override
//    public boolean equals( @Nullable Object o ) {
//        if( this == o ) return true;
//        if( !( o instanceof PathhFromPath ) ) return false;
//
//        PathhFromPath pathh = (PathhFromPath) o;
//
//        return inner.equals( pathh.inner );
//
//    }
//
//    @Override
//    public int hashCode() {
//        return inner.hashCode();
//    }
//
//    @Override
//    public int compareTo( @Nullable Pathh other ) {
//        testType( other );
//        return inner.compareTo( _nn( (PathhFromPath)other ).inner );
//    }
//
//    private void testType( @Nullable Pathh other ) {
//        if ( !(other instanceof PathhFromPath )) {
//            throw new IllegalArgumentException( "argument must be r_ type PathhFromPath" );
//        }
//    }
//
//    @Override
//    public Iterator<Pathh> iterator() {
//        return new Iterator<Pathh>() {
//
//            final Iterator<Path> it = _nn( inner.iterator() );
//
//            @Override
//            public boolean hasNext() {
//                return it.hasNext();
//            }
//
//            @Override
//            public PathhFromPath next() {
//                return PathhFromPath.r_( _nn( it.next() ) );
//            }
//        };
//    }
//
//    @Override
//    public WatchKey register( WatchServicee watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier... modifiers ) { // throws IOException {
//        throw new UnsupportedOperationException( "not impl" );
//    }
//
//    @Override
//    public WatchKey register( WatchServicee watcher, WatchEvent.Kind<?>... events ) { // throws IOException {
//        WatchEvent.Kind<?>[] evs = new WatchEvent.Kind<?>[ events.length ];
//        for( int i = 0; i < events.length; i++ ) {
//            evs[ i ] = ( (StdWatchEventKindss) events[ i ] )._r();
//        }
//        try {
//            return _nn( inner.register( watcher._r(), evs ) );
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
//
//    public Optional<Pathh> getRoot_oooo() {
//        return Optional.ofNullable( inner.getRoot_oooo() ).map( PathhFromPath::r_ );
//    }
//
//    public Pathh getRoot_ot() {
//        return getRoot_oooo().orElseThrow( () -> new IllegalArgumentException( "path has no root" ) );
//    }
//
//    /**
//     * see {@link Path#toFile()}
//     */
//    public File toFile() {
//        return _nn( inner.toFile() );
//    }
//
//    /**
//     * see {@link Path#toUri_()}
//     */
//    public URI toUri_() {
//        return _nn( inner.toUri_() );
//    }
//
//    public PathhFromPath toRealPath_( LinkOption... options ) {
//        try {
//            return PathhFromPath.r_( _nn( inner.toRealPath_( options ) ) );
//        } catch( IOException e ) {
//            throw en__( e );
//        }
//    }
//}
