package de.pfabulist.roast.nio;

import de.pfabulist.roast.Roast;
import de.pfabulist.roast.lang.AutoCloseable_;

import javax.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

import static de.pfabulist.roast.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface SeekableByteChannel_ extends AutoCloseable_, Roast<SeekableByteChannel> {

    static SeekableByteChannel_ r_( SeekableByteChannel seekableByteChannel ) {
        if ( seekableByteChannel instanceof SeekableByteChannel_ ) {
            return (SeekableByteChannel_) seekableByteChannel;
        }

        return new SeekableByteChannel_of( seekableByteChannel );
    }

    SeekableByteChannel position_( long newPosition );

    long position_();

//    default int write_en_( @Nullable ByteBuffer wrap ) {
//        return write_( n_( wrap ) );
//    }

    int write_( ByteBuffer wrap );

    long size_();

//    default int read( @Nullable ByteBuffer allocate ) {
//        return read_( n_(allocate ));
//    }

    int read_( ByteBuffer bb );

    boolean isOpen_();

    SeekableByteChannel truncate_( int size );

//    private final SeekableByteChannel inner;

//    public SeekableByteChannell( SeekableByteChannel seekableByteChannel ) {
//        inner = seekableByteChannel;
//    }
//
//    public static SeekableByteChannell r_( SeekableByteChannel seekableByteChannel ) {
//        return new SeekableByteChannell( seekableByteChannel );
//    }
//
//    @Override
//    public void close() throws IOException {
//        inner.close();
//    }
//
//    public SeekableByteChannell position_( int i ) {
//        try {
//            inner.position_(i);
//            return this;
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//    }
//
//    public long size_() {
//        try {
//            return inner.size_();
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//    }
//
//    /**
//     * see {@link SeekableByteChannel#read(ByteBuffer)}
//     */
//    public int read( ByteBuffer bb ) {
//        try {
//            return inner.read( bb );
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//    }
//
//    public boolean isOpen_() {
//        return inner.isOpen_();
//    }
//
//    public int write_( ByteBuffer byteBuffer ) {
//        try {
//            return inner.write_( byteBuffer );
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//    }
//
//    /**
//     * see {@link SeekableByteChannel#position_()}
//     */
//    public long position_() {
//        try {
//            return inner.position_();
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//    }
//
//    /**
//     * see {@link SeekableByteChannel#truncate_(long)}
//     */
//    public SeekableByteChannell truncate_( long i ) {
//        try {
//            inner.truncate_( i );
//        } catch( IOException e ) {
//            throw en__(e);
//        }
//        return this;
//    }
//
//    @Override
//    public SeekableByteChannel _r() {
//        return inner;
//    }
}
