package de.pfabulist.roast.nio;

import de.pfabulist.roast.functiontypes.Supplier_;

import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

import static de.pfabulist.roast.NonnullCheck.n_;
import static de.pfabulist.roast.functiontypes.Runnable_.v_;
import static de.pfabulist.roast.functiontypes.Supplier_.vn_;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class SeekableByteChannel_of implements SeekableByteChannel_ {

    private final SeekableByteChannel inner;

    public SeekableByteChannel_of( SeekableByteChannel seekableByteChannel ) {
        inner = seekableByteChannel;
    }

    @Override
    public SeekableByteChannel _r() {
        return inner;
    }

    @Override
    public void close_() {
        v_( inner::close );
    }

    @Override
    public SeekableByteChannel position_( long newPosition ) {
        return vn_( () -> n_( inner.position( newPosition )));
    }

    @Override
    public long position_() {
        return Supplier_.vn_( inner::position );
    }

    @Override
    public int write_( ByteBuffer bb ) {
        return vn_( () -> inner.write( bb ));
    }

    @Override
    public long size_() {
        return vn_( inner::size );
    }

    @Override
    public int read_( ByteBuffer bb ) {
        return vn_( () -> inner.read( bb) );
    }

    @Override
    public boolean isOpen_() {
        return vn_( inner::isOpen );
    }

    @Override
    public SeekableByteChannel truncate_( int i ) {
        return vn_( () -> n_( inner.truncate( i ) ));
    }
}
