package de.pfabulist.roast.nio;

import de.pfabulist.roast.functiontypes.Supplier_;

import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;

import static de.pfabulist.roast.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class UserPrincipalLookupService_of implements UserPrincipalLookupService_ {

    private final UserPrincipalLookupService inner;

    public UserPrincipalLookupService_of( UserPrincipalLookupService inner ) {
        this.inner = inner;
    }

    @Override
    public UserPrincipalLookupService _r() {
        return inner;
    }

    @Override
    public UserPrincipal lookupPrincipalByName_( String name ) {
        return Supplier_.vn_( () -> n_( inner.lookupPrincipalByName( name )));
    }
}
