package de.pfabulist.roast.nio;

import de.pfabulist.roast.Roast;
import de.pfabulist.roast.lang.AutoCloseable_;

import javax.annotation.Nullable;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

import static de.pfabulist.roast.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface WatchService_ extends AutoCloseable_, Roast<WatchService> {

    static WatchService_ r_( WatchService watchService ) {
        if ( watchService instanceof WatchService_ ) {
            return (WatchService_) watchService;
        }
        return new WatchService_of( watchService );
    }

    WatchKey take_();

    default Optional<WatchKey> poll( int timeout, @Nullable TimeUnit timeUnit ) {
        return poll_o( timeout, n_( timeUnit ));
    }

    Optional<WatchKey> poll_o( int timeout, TimeUnit timeUnit );

//    Optional<WatchKey> poll();
}
