package de.pfabulist.roast.nio;

import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

import static de.pfabulist.roast.NonnullCheck.n_;
import static de.pfabulist.roast.functiontypes.Supplier_.vn_;
import static de.pfabulist.roast.functiontypes.Runnable_.v_;
import static de.pfabulist.roast.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class WatchService_of implements WatchService_ {
    private final WatchService inner;

    public WatchService_of( WatchService watchService ) {
        inner = watchService;
    }

    @Override
    public void close_() {
        v_( inner::close );
    }

    public WatchKey take_() {
        return vn_( () -> n_( inner.take() ) );
    }

    public Optional<WatchKey> poll_o( int timeout, TimeUnit timeUnit ) {
        try {
            return Optional.ofNullable( inner.poll( timeout, timeUnit ) );
        } catch( InterruptedException e ) {
            throw u( e );
        }
    }

//    public Optional<WatchKey> poll() {
//        return Optional.ofNullable( inner.poll() );
//    }

    public WatchService _r() {
        return inner;
    }
}
