package de.pheasn.pluginupdater;

import java.io.IOException;

public interface Updatable {
	/**
	 * Invoked if an IOException occurs while checking for updates
	 * 
	 * @param e
	 */
	public void updateIOException(IOException e);

	/**
	 * Invoked if the updater thread is interrupted
	 * 
	 * @param e
	 */
	public void updateInterruptedException(InterruptedException e);

	/**
	 * Returns details from the plugin description
	 * 
	 * @param key
	 *            UpdaterKey (MAIN_AUTHOR, NAME or VERSION)
	 * @return Correct part of the description
	 */
	public String getDescription(UpdaterKey key);

	/**
	 * Invoked if new version has been found and being downloaded
	 */
	public void updateNotifyDownloading();

	/**
	 * Invoked if new version has been downloaded and server should be restarted to install update.
	 */
	public void updateNotifyRestarting();

	/**
	 * Invoked if new version is a significant update and the bukkit project page should be visited to check for big changes
	 * 
	 */
	public void updateNotifyReadUpdatedProjectPage();

	/**
	 * Returns the release type of the currently running plugin
	 * @return the release type
	 */
	public ReleaseType getReleaseType();
}
