package de.pheasn.pluginupdater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Updater extends Thread {

	/**
	 * Please use {@link #cancel()} instead
	 */
	@Deprecated
	@Override
	public void interrupt() {
		cancel();
	}

	private boolean scheduleNext = true;
	private boolean updatePending;

	private final Updatable plugin;
	private File pluginFile;
	private final int pluginId;
	private final String apiKey;
	private long interval;
	private ReleaseType releaseType;

	private Timer timer;

	private static final String API_NAME_VALUE = "name"; //$NON-NLS-1$
	private static final String API_LINK_VALUE = "downloadUrl"; //$NON-NLS-1$
	private static final String API_RELEASE_TYPE_VALUE = "releaseType"; //$NON-NLS-1$
	private static final String API_QUERY = "/servermods/files?projectIds="; //$NON-NLS-1$
	private static final String API_HOST = "https://api.curseforge.com"; //$NON-NLS-1$

	/**
	 * Gets a new instance of the updater. Needs to be {@link #start() started}.
	 * 
	 * @param plugin
	 *            JavaPlugin that shall be updated
	 * @param pluginId
	 *            Bukkit.org plugin id
	 * @param pluginFile
	 *            File of the plugin (you can use getFile())
	 * @param apiKey
	 *            Bukkit apiKey, may be null
	 * @param releaseType
	 *            Choose one of the ReleaseTypes
	 */
	public Updater(Updatable plugin, int pluginId, File pluginFile, String apiKey, ReleaseType releaseType) {
		this.plugin = plugin;
		this.pluginFile = pluginFile;
		this.pluginId = pluginId;
		this.apiKey = apiKey;
		this.releaseType = releaseType;
		this.timer = new Timer();
	}

	/**
	 * Changes the preferred release type Won't have effect until <b>after</b> next update check.
	 * 
	 * @param releaseType
	 */
	public void setReleaseType(ReleaseType releaseType) {
		this.releaseType = releaseType;
	}

	/**
	 * If update checks have somehow been canceled, they can be restarted by this method.
	 */
	public void scheduleNext() {
		scheduleNext = true;
	}

	/**
	 * Checks for updates. Not recommended to do this "manually". <br />
	 * Use {@link #scheduleNext()} instead
	 * 
	 * @return True if update has been found and downloaded
	 */
	@Deprecated
	public boolean check() {
		if (!updatePending) {
			URL url = null;
			try {
				url = new URL(API_HOST + API_QUERY + pluginId);
			} catch (MalformedURLException e) {
				plugin.updateIOException(e);
				return false;
			}
			try {
				URLConnection con = url.openConnection();
				if (apiKey != null) {
					con.addRequestProperty("X-API-Key", apiKey); //$NON-NLS-1$
				}
				con.addRequestProperty("User-Agent", plugin.getDescription(UpdaterKey.NAME) + "/v" //$NON-NLS-1$ //$NON-NLS-2$
						+ plugin.getDescription(UpdaterKey.VERSION) + " (by " //$NON-NLS-1$
						+ plugin.getDescription(UpdaterKey.MAIN_AUTHOR) + ")"); //$NON-NLS-1$

				final BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
				String response = reader.readLine();
				JSONArray array = (JSONArray) JSONValue.parse(response);
				if (array.size() > 0) {
					for (int i = array.size() - 1; i >= 0; i--) {
						JSONObject version = (JSONObject) array.get(i);
						String versionLink = (String) version.get(API_LINK_VALUE);
						String versionName = (String) version.get(API_NAME_VALUE);
						String releaseTypeName = ((String) version.get(API_RELEASE_TYPE_VALUE)).toUpperCase();
						if(releaseTypeName.equals("RELEASE")) releaseTypeName = "STABLE";
						ReleaseType releaseType = ReleaseType.valueOf(releaseTypeName);
						ReleaseType prefType = this.releaseType;
						if (prefType == null) {
							prefType = ReleaseType.STABLE;
						}
						if (releaseType != null && releaseType.compareTo(prefType) >= 0) {
							PluginVersion pendingVersion = new PluginVersion(versionName, releaseType);
							PluginVersion currentVersion = new PluginVersion(
									plugin.getDescription(UpdaterKey.VERSION), plugin.getReleaseType());
							if (pendingVersion.compareTo(currentVersion) == 1) {
								this.notifyIfNewMainVersion(pendingVersion, currentVersion);
								URL dwnurl = new URL(versionLink);
								InputStream in = dwnurl.openStream();
								File file = new File("./plugins/update/" + pluginFile.getName());
								file.getParentFile().mkdirs();
								if (file.exists()) {
									file.delete();
								}
								file.createNewFile();
								FileOutputStream out = new FileOutputStream(file);
								int fetched;
								byte[] buffer = new byte[4096];
								while ((fetched = in.read(buffer)) != -1) {
									out.write(buffer, 0, fetched);
								}
								out.close();
								in.close();
								updatePending = true;
								return true;
							} else {
								return false;
							}
						}
					}
				}
				reader.close();
			} catch (IOException e) {
				plugin.updateIOException(e);
			}
		}
		return false;
	}

	@Override
	public void run() {
		super.run();
		try {
			while (true) {
				if (scheduleNext) {
					timer.schedule(new UpdateCheckTask(this, plugin), interval);
					scheduleNext = false;
				}
				Thread.sleep(10000);
			}
		} catch (InterruptedException e) {
			plugin.updateInterruptedException(e);
		}
	}

	private void notifyIfNewMainVersion(PluginVersion version1, PluginVersion version2) {
		if (version1.isSignificantlyNewerThan(version2, 1)) {
			plugin.updateNotifyReadUpdatedProjectPage();
		}
	}

	/**
	 * Cancels all update checking tasks. You can restart the updater by invoking {@link #scheduleNext()}
	 */
	public void cancel() {
		timer.cancel();
		timer = new Timer();
	}

	public boolean hasUpdatePending() {
		return updatePending;
	}

}
