/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.pluginupdater;

import de.pheasn.pluginupdater.ReleaseChannel;

public class PluginVersion
implements Comparable<PluginVersion> {
    private final int[] versionArr;
    private final ReleaseChannel releaseChannel;

    public PluginVersion(String versionString, ReleaseChannel releaseChannel) {
        versionString = this.removeNonNumeric(versionString);
        this.releaseChannel = releaseChannel;
        String[] splitted = versionString.split("\\.");
        this.versionArr = new int[splitted.length];
        for (int i = 0; i < splitted.length; ++i) {
            this.versionArr[i] = Integer.parseInt(splitted[i]);
        }
    }

    private String removeNonNumeric(String inputString) {
        StringBuilder output = new StringBuilder();
        for (char c : inputString.toCharArray()) {
            if (!Character.isDigit(c) && c != '.') continue;
            output.append(c);
        }
        return output.toString();
    }

    @Override
    public int compareTo(PluginVersion v2) {
        int j;
        int i;
        for (i = 0; i < this.versionArr.length && i < v2.versionArr.length; ++i) {
            if (this.versionArr[i] > v2.versionArr[i]) {
                return 1;
            }
            if (this.versionArr[i] >= v2.versionArr[i]) continue;
            return -1;
        }
        if (i == v2.versionArr.length && i == this.versionArr.length) {
            int compareResult = this.releaseChannel.compareTo(v2.releaseChannel);
            if (compareResult < 0) {
                return -1;
            }
            if (compareResult > 0) {
                return 1;
            }
            return 0;
        }
        for (j = i; j < this.versionArr.length; ++j) {
            if (this.versionArr[j] == 0) continue;
            return 1;
        }
        for (j = i; j < v2.versionArr.length; ++j) {
            if (v2.versionArr[j] == 0) continue;
            return -1;
        }
        int compareResult = this.releaseChannel.compareTo(v2.releaseChannel);
        if (compareResult < 0) {
            return -1;
        }
        if (compareResult > 0) {
            return 1;
        }
        return 0;
    }

    public boolean isSignificantlyNewerThan(PluginVersion version2, int i) {
        int j;
        for (j = 0; j <= i && j < this.versionArr.length && j < version2.versionArr.length; ++j) {
            if (this.versionArr[j] <= version2.versionArr[j]) continue;
            return true;
        }
        while (j <= i && j < this.versionArr.length) {
            if (this.versionArr[j] != 0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.releaseChannel == null ? 0 : this.releaseChannel.hashCode());
        boolean nonZeroFound = false;
        for (int i = this.versionArr.length - 1; i >= 0; --i) {
            if (this.versionArr[i] != 0) {
                nonZeroFound = true;
            }
            if (!nonZeroFound) continue;
            result = 31 * result + this.versionArr[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginVersion other = (PluginVersion)obj;
        return this.compareTo(other) == 0;
    }
}

