/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.pluginupdater;

import de.pheasn.pluginupdater.PluginVersion;
import de.pheasn.pluginupdater.ReleaseChannel;
import de.pheasn.pluginupdater.Updatable;
import de.pheasn.pluginupdater.UpdateCheckTask;
import de.pheasn.pluginupdater.UpdaterKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Updater
extends Thread {
    private boolean scheduleNext = true;
    private boolean updatePending;
    private final Updatable plugin;
    private File pluginFile;
    private final int pluginId;
    private final String apiKey;
    private long interval;
    private ReleaseChannel releaseChannel;
    private Timer timer;
    private static final String API_NAME_VALUE = "name";
    private static final String API_LINK_VALUE = "downloadUrl";
    private static final String API_RELEASE_TYPE_VALUE = "releaseType";
    private static final String API_QUERY = "/servermods/files?projectIds=";
    private static final String API_HOST = "https://api.curseforge.com";

    @Override
    @Deprecated
    public void interrupt() {
        this.cancel();
    }

    public Updater(Updatable plugin, int pluginId, File pluginFile, String apiKey, ReleaseChannel releaseChannel) {
        this.plugin = plugin;
        this.pluginFile = pluginFile;
        this.pluginId = pluginId;
        this.apiKey = apiKey;
        this.releaseChannel = releaseChannel;
        this.timer = new Timer();
    }

    public void setReleaseType(ReleaseChannel releaseChannel) {
        this.releaseChannel = releaseChannel;
    }

    public void scheduleNext() {
        this.scheduleNext = true;
    }

    @Deprecated
    public boolean check() {
        if (!this.updatePending) {
            URL url = null;
            try {
                url = new URL("https://api.curseforge.com/servermods/files?projectIds=" + this.pluginId);
            }
            catch (MalformedURLException e) {
                this.plugin.updateIOException(e);
                return false;
            }
            try {
                URLConnection con = url.openConnection();
                if (this.apiKey != null) {
                    con.addRequestProperty("X-API-Key", this.apiKey);
                }
                con.addRequestProperty("User-Agent", this.plugin.getDescription(UpdaterKey.NAME) + "/v" + this.plugin.getDescription(UpdaterKey.VERSION) + " (by " + this.plugin.getDescription(UpdaterKey.MAIN_AUTHOR) + ")");
                BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String response = reader.readLine();
                JSONArray array = (JSONArray)JSONValue.parse((String)response);
                if (array.size() > 0) {
                    for (int i = array.size() - 1; i >= 0; --i) {
                        JSONObject version = (JSONObject)array.get(i);
                        String versionLink = (String)version.get((Object)API_LINK_VALUE);
                        String versionName = (String)version.get((Object)API_NAME_VALUE);
                        String releaseTypeName = ((String)version.get((Object)API_RELEASE_TYPE_VALUE)).toUpperCase();
                        if (releaseTypeName.equals("RELEASE")) {
                            releaseTypeName = ReleaseChannel.STABLE.toString();
                        }
                        ReleaseChannel releaseChannel = ReleaseChannel.valueOf(releaseTypeName);
                        ReleaseChannel prefType = this.releaseChannel;
                        if (prefType == null) {
                            prefType = ReleaseChannel.STABLE;
                        }
                        if (releaseChannel == null || releaseChannel.compareTo(prefType) < 0) continue;
                        PluginVersion pendingVersion = new PluginVersion(versionName, releaseChannel);
                        PluginVersion currentVersion = new PluginVersion(this.plugin.getDescription(UpdaterKey.VERSION), this.plugin.getReleaseChannel());
                        if (pendingVersion.compareTo(currentVersion) == 1) {
                            int fetched;
                            this.notifyIfNewMainVersion(pendingVersion, currentVersion);
                            URL dwnurl = new URL(versionLink);
                            InputStream in = dwnurl.openStream();
                            File file = new File("./plugins/update/" + this.pluginFile.getName());
                            file.getParentFile().mkdirs();
                            if (file.exists()) {
                                file.delete();
                            }
                            file.createNewFile();
                            FileOutputStream out = new FileOutputStream(file);
                            byte[] buffer = new byte[4096];
                            while ((fetched = in.read(buffer)) != -1) {
                                out.write(buffer, 0, fetched);
                            }
                            out.close();
                            in.close();
                            this.updatePending = true;
                            return true;
                        }
                        return false;
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                this.plugin.updateIOException(e);
            }
        }
        return false;
    }

    @Override
    public void run() {
        super.run();
        try {
            while (true) {
                if (this.scheduleNext) {
                    this.timer.schedule((TimerTask)new UpdateCheckTask(this, this.plugin), this.interval);
                    this.scheduleNext = false;
                }
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            this.plugin.updateInterruptedException(e);
            return;
        }
    }

    private void notifyIfNewMainVersion(PluginVersion version1, PluginVersion version2) {
        if (version1.isSignificantlyNewerThan(version2, 1)) {
            this.plugin.updateNotifyReadUpdatedProjectPage();
        }
    }

    public void cancel() {
        this.timer.cancel();
        this.timer = new Timer();
    }

    public boolean hasUpdatePending() {
        return this.updatePending;
    }
}

