package de.pheasn.pluginupdater;

public enum ReleaseChannel {
  ALPHA, BETA, STABLE;

  /**
   * Parses a string to a ReleaseChannel. If the input is invalid, STABLE is returned.
   * 
   * @param releaseTypeName the name of the ReleaseChannel. "alpha", "beta" or "stable"/"release"
   * @return the ReleaseChannel
   */
  public static ReleaseChannel parse(String releaseTypeName) {
    if (releaseTypeName == null) {
      return STABLE;
    }

    switch (releaseTypeName.toLowerCase()) {
      case "alpha":
        return ALPHA;
      case "beta":
        return BETA;
      default:
        return STABLE;
    }
  }
}
