package de.pheasn.pluginupdater;

import java.io.File;

public interface Updatable {

  /**
   * Returns the plugin's .jar file. This should invoke the protected method getFile() of
   * JavaPlugin.
   *
   * @return the plugin file
   */
  File getFile();

  /**
   * Returns the version of the plugin.
   *
   * @return the version
   */
  String getVersion();

  /**
   * Invoked if new version has been downloaded and server should be restarted to install update.
   *
   * @param newVersion the new version that has been downloaded
   */
  void updateNotify(String newVersion);

  /**
   * Returns the release type of the currently running plugin.
   *
   * @return a ReleaseChannel
   */
  ReleaseChannel getReleaseChannel();
}
