/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.pluginupdater;

import com.google.common.annotations.VisibleForTesting;
import de.pheasn.pluginupdater.AutoValue_Updater;
import de.pheasn.pluginupdater.PluginVersion;
import de.pheasn.pluginupdater.ReleaseChannel;
import de.pheasn.pluginupdater.Updatable;
import de.pheasn.pluginupdater.UpdateCheckFinishedEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class Updater {
    @VisibleForTesting
    static boolean debug = false;
    @VisibleForTesting
    UpdateCheckFinishedEvent test = null;
    private static final String API_NAME_VALUE = "name";
    private static final String API_LINK_VALUE = "downloadUrl";
    private static final String API_RELEASE_TYPE_VALUE = "releaseType";
    private static final String API_QUERY = "/servermods/files?projectIds=";
    private static final String API_HOST = "https://api.curseforge.com";
    private static final long MIN_INTERVAL = 5L;
    private static final long DEFAULT_INTERVAL = 18L;
    private final TimerTask timerTask;
    private Timer timer = new Timer();
    private boolean updatePending = false;

    public static Builder builder() {
        return new AutoValue_Updater.Builder().interval(18L).releaseChannel(ReleaseChannel.STABLE);
    }

    @Nullable
    public abstract String getApiKey();

    public abstract ReleaseChannel getReleaseChannel();

    abstract long getInterval();

    public abstract int getPluginId();

    public abstract Updatable getPlugin();

    Updater() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Updater.this.checkForUpdate();
            }
        };
    }

    public void setInterval(long interval) {
        long msInterval = !debug ? (interval < 5L ? 18L : interval) * 60L * 1000L : interval;
        this.cancel();
        this.timer.schedule(this.timerTask, msInterval, msInterval);
    }

    public void cancel() {
        this.timer.cancel();
        this.timer = new Timer();
    }

    void checkForUpdate() {
        block22: {
            if (this.updatePending) {
                return;
            }
            this.updatePending = true;
            URL url = null;
            try {
                url = new URL("https://api.curseforge.com/servermods/files?projectIds=" + this.getPluginId());
            }
            catch (MalformedURLException e) {
                this.updatePending = false;
                if (debug) {
                    this.test.updateCheckFinishedEvent();
                }
                return;
            }
            FileOutputStream fileOutput = null;
            try {
                URLConnection con = url.openConnection();
                if (this.getApiKey() != null) {
                    con.addRequestProperty("X-API-Key", this.getApiKey());
                }
                con.addRequestProperty("User-Agent", "PluginUpdater by Pheasn");
                BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), Charset.forName("US-ASCII")));
                String response = reader.readLine();
                reader.close();
                JSONArray array = (JSONArray)JSONValue.parse((String)response);
                if (array.isEmpty()) break block22;
                for (int i = array.size() - 1; i >= 0; --i) {
                    JSONObject version = (JSONObject)array.get(i);
                    String versionLink = (String)version.get((Object)API_LINK_VALUE);
                    String versionName = (String)version.get((Object)API_NAME_VALUE);
                    String releaseTypeName = ((String)version.get((Object)API_RELEASE_TYPE_VALUE)).toUpperCase();
                    ReleaseChannel pendingChannel = ReleaseChannel.parse(releaseTypeName);
                    if (pendingChannel.compareTo(this.getReleaseChannel()) < 0) continue;
                    PluginVersion pendingVersion = new PluginVersion(versionName, pendingChannel);
                    PluginVersion currentVersion = new PluginVersion(this.getPlugin().getVersion(), this.getPlugin().getReleaseChannel());
                    if (pendingVersion.compareTo(currentVersion) == 1) {
                        File file = new File(new File(this.getPlugin().getFile().getParentFile(), "update"), this.getPlugin().getFile().getName());
                        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                            this.updatePending = false;
                        } else if (file.exists() && !file.delete()) {
                            this.updatePending = false;
                        } else if (!file.createNewFile()) {
                            this.updatePending = false;
                        } else {
                            int fetched;
                            URL dwnurl = new URL(versionLink);
                            InputStream in = dwnurl.openStream();
                            fileOutput = new FileOutputStream(file);
                            byte[] buffer = new byte[4096];
                            while ((fetched = in.read(buffer)) != -1) {
                                fileOutput.write(buffer, 0, fetched);
                            }
                            fileOutput.close();
                            in.close();
                            this.getPlugin().updateNotify(versionName);
                        }
                    } else {
                        this.updatePending = false;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (fileOutput != null) {
                    try {
                        fileOutput.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                if (debug) {
                    e.printStackTrace();
                }
                this.updatePending = false;
            }
        }
        if (debug) {
            this.test.updateCheckFinishedEvent();
        }
    }

    public static abstract class Builder {
        public abstract Builder releaseChannel(ReleaseChannel var1);

        public abstract Builder plugin(Updatable var1);

        public abstract Builder pluginId(int var1);

        public abstract Builder interval(long var1);

        @Nullable
        public abstract Builder apiKey(String var1);

        abstract Updater autoBuild();

        public Updater build() {
            Updater updater = this.autoBuild();
            if (!debug && updater.getInterval() < 5L) {
                throw new IllegalArgumentException("Interval must be greater or equal 5 minutes");
            }
            updater.setInterval(updater.getInterval());
            return updater;
        }
    }
}

