/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.maven.plugins.dependencyresolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedObjectValueSource;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="resolve-dependencies", threadSafe=true)
public class DependencyResolver
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyResolver.class);
    private static final String LIB_DOWNLOAD = "lib-download";
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="dependencies", required=true)
    private List<String> dependencies;
    @Parameter(property="outputFileNameMapping", defaultValue="${artifact.artifactId}.${artifact.extension}")
    private String outputFileNameMapping;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List artifactResults;
        CollectRequest collectRequest = new CollectRequest();
        for (String dependency : this.dependencies) {
            boolean noTransitive = dependency.startsWith("!");
            String normalizedDepencendy = dependency.replaceAll("^!", "");
            if (noTransitive) {
                List<Exclusion> exclusions = Arrays.asList(new Exclusion("*", "*", "*", "*"));
                collectRequest.addDependency(new Dependency((Artifact)new DefaultArtifact(normalizedDepencendy), "compile", null, exclusions));
                continue;
            }
            collectRequest.addDependency(new Dependency((Artifact)new DefaultArtifact(normalizedDepencendy), "compile"));
        }
        collectRequest.addRepository(new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2/").build());
        collectRequest.addRepository(new RemoteRepository.Builder("snapshots", "default", "https://oss.sonatype.org/content/repositories/snapshots/").build());
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        try {
            artifactResults = this.repoSystem.resolveDependencies(this.repoSession, dependencyRequest).getArtifactResults();
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Path projectPath = this.project.getBasedir().toPath();
        Path libDownloadPath = projectPath.resolve(LIB_DOWNLOAD);
        if (Files.isDirectory(libDownloadPath, new LinkOption[0])) {
            try {
                LOGGER.info("Delete contents of {}", (Object)libDownloadPath);
                Files.walk(libDownloadPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not delete " + libDownloadPath, (Exception)e);
            }
        }
        try {
            Files.createDirectories(libDownloadPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create " + libDownloadPath, (Exception)e);
        }
        for (ArtifactResult artifactResult : artifactResults) {
            Artifact artifact = artifactResult.getArtifact();
            String name = DependencyResolver.getArtifactFilename(artifact, this.outputFileNameMapping);
            Path destinationPath = libDownloadPath.resolve(name);
            try {
                LOGGER.info("Copy to {}", (Object)destinationPath);
                Files.copy(artifact.getFile().toPath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy to " + destinationPath, (Exception)e);
            }
        }
        List pathEntries = artifactResults.stream().map(r -> "lib-download/" + DependencyResolver.getArtifactFilename(r.getArtifact(), this.outputFileNameMapping)).collect(Collectors.toList());
        List<String> bundleClassPath = DependencyResolver.parseBundleClassPath(projectPath.resolve(Paths.get("META-INF/MANIFEST.MF", new String[0])));
        List missingBundeClassPath = pathEntries.stream().filter(entry -> !bundleClassPath.contains(entry)).collect(Collectors.toList());
        List<String> binIncludes = DependencyResolver.parseBinIncludes(projectPath.resolve(Paths.get("build.properties", new String[0])));
        List missingBinIncludes = pathEntries.stream().filter(entry -> !binIncludes.contains(entry)).collect(Collectors.toList());
        if (!missingBundeClassPath.isEmpty() || !missingBinIncludes.isEmpty()) {
            String shortMessage = "Missing entries in MANIFEST.MF and/or build.properties";
            Object longMessage = "\n";
            if (!missingBundeClassPath.isEmpty()) {
                longMessage = (String)longMessage + "Missing entries in Bundle-ClassPath in MANIFEST.MF:\n";
                longMessage = (String)longMessage + String.join((CharSequence)"\n", missingBundeClassPath);
                longMessage = (String)longMessage + "\n\n";
            }
            if (!missingBinIncludes.isEmpty()) {
                longMessage = (String)longMessage + "Missing entries in bin.includes in build.properties:\n";
                longMessage = (String)longMessage + String.join((CharSequence)"\n", missingBinIncludes);
                longMessage = (String)longMessage + "\n\n";
            }
            throw new MojoExecutionException(null, shortMessage, (String)longMessage);
        }
    }

    static String getArtifactFilename(Artifact artifact, String template) {
        PrefixedObjectValueSource valueSource = new PrefixedObjectValueSource("artifact", (Object)artifact);
        FixedStringSearchInterpolator interpolator = FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{valueSource});
        return interpolator.interpolate(template);
    }

    static List<String> parseBundleClassPath(Path manifest) throws MojoExecutionException {
        Manifest parsedManifest;
        try {
            parsedManifest = new Manifest(new FileInputStream(manifest.toFile()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read " + manifest);
        }
        String bundleClassPath = parsedManifest.getMainAttributes().getValue("Bundle-ClassPath");
        if (bundleClassPath == null) {
            throw new MojoExecutionException("Bundle-ClassPath is missing");
        }
        String[] classPathEntries = bundleClassPath.split(",");
        return Arrays.asList(classPathEntries);
    }

    static List<String> parseBinIncludes(Path buildProperties) throws MojoExecutionException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(buildProperties.toFile()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read " + buildProperties);
        }
        String binIncludes = properties.getProperty("bin.includes");
        if (binIncludes == null) {
            throw new MojoExecutionException("bin.includes is missing");
        }
        String[] binIncludeEntries = binIncludes.split(",");
        return Arrays.asList(binIncludeEntries);
    }
}

