/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.collision;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi_demos.collision.DeathScreen;

class Frog
extends Image
implements FrameUpdateListener {
    private boolean canJump = true;
    private static double MAX_SPEED = 4.0;

    public Frog() {
        super("froggy/Frog.png", 25.0);
        this.makeDynamic();
        this.setRotationLocked(true);
    }

    public void setJumpEnabled(boolean jumpEnabled) {
        this.canJump = jumpEnabled;
    }

    public void kill() {
        Game.transitionToScene((Scene)new DeathScreen());
    }

    public void onFrameUpdate(double pastTime) {
        Vector velocity = this.getVelocity();
        if (velocity.getX() < 0.0) {
            this.setFlipHorizontal(true);
        } else {
            this.setFlipHorizontal(false);
        }
        if (Game.isKeyPressed((int)65)) {
            if (velocity.getX() > 0.0) {
                this.setVelocity(new Vector(0.0, velocity.getY()));
            }
            this.applyForce(Vector.LEFT.multiply(600.0));
        } else if (Game.isKeyPressed((int)68)) {
            if (velocity.getX() < 0.0) {
                this.setVelocity(new Vector(0.0, velocity.getY()));
            }
            this.applyForce(Vector.RIGHT.multiply(600.0));
        }
        if (Math.abs(velocity.getX()) > MAX_SPEED) {
            this.setVelocity(new Vector(MAX_SPEED * Math.signum(velocity.getX()), velocity.getY()));
        }
        if (this.isGrounded() && velocity.getY() <= 0.0 && this.canJump) {
            this.setVelocity(new Vector(velocity.getX(), 0.0));
            this.applyImpulse(Vector.UP.multiply(180.0));
        }
    }
}

