/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.physics.single_aspects;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import java.text.DecimalFormat;

public class ElasticityDemo
extends Scene {
    private final Rectangle ground;

    public ElasticityDemo() {
        this.getCamera().setMeter(20.0);
        this.ground = new Rectangle(24.0, 1.0);
        this.ground.setPosition(-12.0, -16.0);
        this.ground.setElasticity(0.0);
        this.ground.makeStatic();
        this.setGravity(0.0, -9.81);
        this.add(new Actor[]{this.ground});
        double elasticity = 0.0;
        double x = -11.5;
        while (x < 12.0) {
            this.createCircleWithElasticity(x, elasticity);
            elasticity += 0.1;
            x += 2.0;
        }
    }

    private void createCircleWithElasticity(double x, double elasticity) {
        Circle circle = new Circle(1.0);
        this.add(new Actor[]{circle});
        circle.setElasticity(elasticity);
        circle.setPosition(x, 5.0);
        circle.makeDynamic();
        DecimalFormat df = new DecimalFormat("0.00");
        Text label = new Text(df.format(elasticity), 0.8);
        label.setPosition(x, -17.0);
        label.makeStatic();
        this.add(new Actor[]{label});
    }

    public static void main(String[] args) {
        Game.start((int)600, (int)800, (Scene)new ElasticityDemo());
    }
}

