/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.physics.single_aspects;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.event.KeyEvent;

public class GravityDemo
extends Scene
implements KeyStrokeListener {
    private final Circle circle;

    public GravityDemo() {
        this.getCamera().setMeter(45.0);
        this.circle = this.createCircle();
        this.circle.makeDynamic();
        this.setGravity(0.0, -9.81);
        this.createBorder(-5.0, 4.5, false);
        this.createBorder(-5.0, -5.0, false);
        this.createBorder(-5.0, -5.0, true);
        this.createBorder(4.5, -5.0, true);
    }

    private Rectangle createBorder(double x, double y, boolean vertical) {
        Rectangle rectangle = !vertical ? new Rectangle(10.0, 0.5) : new Rectangle(0.5, 10.0);
        rectangle.setPosition(x, y);
        rectangle.makeStatic();
        this.add(new Actor[]{rectangle});
        return rectangle;
    }

    public void onKeyDown(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 38: {
                this.setGravity(0.0, 9.81);
                break;
            }
            case 40: {
                this.setGravity(0.0, -9.81);
                break;
            }
            case 39: {
                this.setGravity(9.81, 0.0);
                break;
            }
            case 37: {
                this.setGravity(-9.81, 0.0);
                break;
            }
            case 32: {
                this.circle.sleep();
            }
        }
    }

    public void setGravity(double x, double y) {
        this.circle.awake();
        super.setGravity(x, y);
    }

    public static void main(String[] args) {
        Game.setDebug((boolean)true);
        Game.start((Scene)new GravityDemo());
    }
}

