/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.scenes;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.animation.CircleAnimation;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import java.awt.event.KeyEvent;

public class MainScene
extends Scene
implements KeyStrokeListener {
    private PauseMenu pauseMenu = new PauseMenu(this);

    public MainScene() {
        Rectangle toAnimate = new Rectangle(5.0, 2.0);
        toAnimate.setCenter(0.0, -5.0);
        toAnimate.setColor("orange");
        CircleAnimation animation = new CircleAnimation((Actor)toAnimate, new Vector(0.0, 0.0), 8.0, true, true);
        this.addFrameUpdateListener((FrameUpdateListener)animation);
        this.add(new Actor[]{toAnimate});
        this.addKeyStrokeListener(this);
        Text info = new Text("Pause mit P", 0.5);
        info.setCenter(-7.0, -5.0);
        this.add(new Actor[]{info});
    }

    public void onKeyDown(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 80) {
            this.gotoPause();
        }
    }

    private void gotoPause() {
        Game.transitionToScene((Scene)this.pauseMenu);
    }

    public static void main(String[] args) {
        Game.start((int)600, (int)400, (Scene)new MainScene());
    }

    private class PauseMenu
    extends Scene {
        private Scene mainScene;

        public PauseMenu(Scene mainScene2) {
            this.mainScene = mainScene2;
            MenuItem back = new MenuItem(new Vector(0.0, -5.0), "Zur\u00fcck");
            this.add(new Actor[]{back, back.label});
            Text headline = new Text("Mach mal Pause.", 2.0);
            headline.setCenter(0.0, 3.0);
            this.add(new Actor[]{headline});
        }

        private class MenuItem
        extends Rectangle
        implements MouseClickListener,
        FrameUpdateListener {
            private Text label;

            public MenuItem(Vector center, String labelText) {
                super(10.0, 1.5);
                this.label = new Text(labelText, 1.0);
                this.label.setLayerPosition(1);
                this.label.setColor("black");
                this.label.setCenter(center);
                this.setLayerPosition(0);
                this.setColor("blueGreen");
                this.setCenter(center);
            }

            public void onMouseDown(Vector clickLoc, MouseButton mouseButton) {
                if (this.contains(clickLoc)) {
                    Game.transitionToScene((Scene)PauseMenu.this.mainScene);
                }
            }

            public void onFrameUpdate(double pastTime) {
                if (this.contains(Game.getMousePositionInCurrentScene())) {
                    this.setColor("blue");
                } else {
                    this.setColor("blueGreen");
                }
            }
        }
    }
}

