/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.small_games;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Layer;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.Polygon;
import de.pirckheimer_gymnasium.engine_pi.actor.PrismaticJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.RevoluteJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.TileMap;
import de.pirckheimer_gymnasium.engine_pi.actor.TileRegistration;
import de.pirckheimer_gymnasium.engine_pi.animation.ValueAnimator;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import java.awt.Color;
import java.util.Objects;

public class CarDemo
extends Scene
implements FrameUpdateListener {
    private static final int WIDTH = 1240;
    private static final int HEIGHT = 812;
    private static final double GROUND_FRICTION = 0.6;
    private static final double GROUND_RESTITUTION = 0.3;
    private static final int MOTOR_SPEED = 80;
    private static final Color GROUND_COLOR = new Color(85, 86, 81);
    private static final int ZOOM = 60;
    private final CarBody carBody;
    private final Wheel wheelFront;
    private final Wheel wheelBack;

    public CarDemo() {
        this.setBackgroundColor(new Color(207, 239, 252));
        Layer blend = new Layer();
        Rectangle blender = new Rectangle(20.666666666666668, 13.533333333333333);
        blender.setColor(Color.BLACK);
        blend.add(new Actor[]{blender});
        blend.setParallaxRotation(0.0);
        blend.setParallaxPosition(0.0, 0.0);
        blend.setLayerPosition(10);
        this.addLayer(blend);
        this.delay(0.2, () -> {
            ValueAnimator valueAnimator = blender.animateOpacity(0.3, 0.0);
        });
        Layer background = new Layer();
        background.setLayerPosition(-2);
        background.setParallaxPosition(0.5, -0.025);
        Rectangle backgroundColor = new Rectangle(400.0, 100.0);
        backgroundColor.setPosition(-200.0, -105.0);
        backgroundColor.setColor(new Color(0, 194, 111));
        background.add(new Actor[]{backgroundColor});
        int i = -200;
        while (i < 200) {
            background.add(new Actor[]{this.createBackgroundTile(i)});
            i += 10;
        }
        this.addLayer(background);
        this.createGround(-70.0, -49.0).setColor(new Color(200, 104, 73));
        Ground left = this.createGround(-50.0, -20.0);
        Ground middle = this.createGround(-10.0, 70.0);
        Ground right = this.createGround(85.0, 170.0);
        this.createGround(169.0, 200.0).setColor(new Color(200, 104, 73));
        this.createRope(-20, -10, (Actor)left, (Actor)middle);
        this.createRope(70, 85, (Actor)middle, (Actor)right);
        this.createHill(5.0, Random.range((int)1, (int)2));
        this.createHill(25.0, Random.range((int)1, (int)2));
        this.createHill(45.0, Random.range((int)1, (int)2));
        Layer decoration = new Layer();
        decoration.setLayerPosition(-1);
        TileRegistration tiles = new TileRegistration(27, 1, 0.5);
        tiles.setPosition(-9.0, -10.0);
        tiles.makeStatic();
        int i2 = 0;
        while (i2 < tiles.getTileCountX()) {
            tiles.setTile(i2, 0, TileMap.createFromImage((String)"car/tile01.png"));
            ++i2;
        }
        decoration.add(new Actor[]{tiles});
        this.addLayer(decoration);
        this.carBody = new CarBody(0.0, -8.0);
        this.wheelFront = new Wheel(1.36, -8.75, new Axle(1.36, -8.6, this.carBody));
        this.wheelBack = new Wheel(-1.0, -8.75, new Axle(-1.0, -8.6, this.carBody));
        this.add(new Actor[]{this.wheelFront, this.wheelBack});
        this.setGravity(Vector.vector((double)0.0, (double)-9.81));
        this.getCamera().setMeter(60.0);
        this.getCamera().setFocus((Actor)this.carBody);
        this.getCamera().setOffset(Vector.vector((double)0.0, (double)3.0));
    }

    private Actor createBackgroundTile(int x) {
        Image image = new Image("car/background-color-grass.png", 10.0, 10.0);
        image.setPosition((double)x, -7.0);
        image.makeStatic();
        return image;
    }

    private void createRope(int startX, int endX, Actor left, Actor right) {
        int length = endX - startX;
        RopeSegment[] rope = new RopeSegment[length];
        int i = 0;
        while (i < length) {
            rope[i] = new RopeSegment(0.8, 0.2);
            rope[i].setPosition((double)(startX + i) + 0.1, -10.2);
            rope[i].setColor(new Color(175, 90, 30));
            rope[i].makeDynamic();
            rope[i].setDensity(150.0);
            rope[i].setFriction(0.6);
            rope[i].setElasticity(0.3);
            rope[i].setBorderRadius(0.5);
            if (i == 0) {
                rope[0].createRevoluteJoint(left, Vector.vector((double)-0.1, (double)0.2)).setLimits(0.0, 0.1);
            } else {
                if (i == length - 1) {
                    rope[length - 1].createRevoluteJoint(right, Vector.vector((double)0.9, (double)0.2)).setLimits(0.0, 0.1);
                }
                rope[i - 1].createRevoluteJoint((Actor)rope[i], Vector.vector((double)0.9, (double)0.2)).setLimits(0.0, 0.1);
            }
            ++i;
        }
        this.add((Actor[])rope);
    }

    private Ground createGround(double startX, double endX) {
        Ground ground = new Ground(startX, endX);
        this.add(new Actor[]{ground});
        return ground;
    }

    private void createHill(double x, double height) {
        double offset = 180.0;
        int j = 0;
        while (j < 39) {
            HillSegment ground = new HillSegment(Vector.vector((double)(x + (double)((float)j / 2.0f)), (double)-10.0), Vector.vector((double)(x + (double)((float)j / 2.0f) + 1.0), (double)-10.0), Vector.vector((double)(x + (double)((float)(j + 1) / 2.0f)), (double)(-10.0 + Math.cos(Math.toRadians((double)((float)(j + 1) / 2.0f * 18.0f) + offset)) * height + height)), Vector.vector((double)(x + (double)((float)j / 2.0f)), (double)(-10.0 + Math.cos(Math.toRadians((double)((float)j / 2.0f * 18.0f) + offset)) * height + height)));
            ground.moveBy(0.0, -0.01);
            ground.makeStatic();
            ground.setColor(GROUND_COLOR);
            ground.setFriction(0.6);
            ground.setElasticity(0.3);
            ground.setDensity(50.0);
            this.add(new Actor[]{ground});
            ++j;
        }
    }

    public void onFrameUpdate(double pastTime) {
        boolean right;
        boolean left = Game.isKeyPressed((int)74);
        if (left ^ (right = Game.isKeyPressed((int)76))) {
            this.wheelFront.setMotorSpeed(right ? 80 : -80);
            this.wheelBack.setMotorSpeed(right ? 80 : -80);
        } else if (Game.isKeyPressed((int)32)) {
            this.wheelFront.setMotorSpeed(0);
            this.wheelBack.setMotorSpeed(0);
        } else {
            this.wheelFront.setMotorEnabled(false);
            this.wheelBack.setMotorEnabled(false);
        }
        if (this.carBody.getCenter().getX() < -65.0) {
            this.carBody.applyForce(Vector.vector((double)(10000.0 * (-65.0 - this.carBody.getCenter().getX())), (double)0.0), this.carBody.getCenter());
        } else if (this.carBody.getCenter().getX() > 195.0) {
            this.carBody.applyForce(Vector.vector((double)(10000.0 * (195.0 - this.carBody.getCenter().getX())), (double)0.0), this.carBody.getCenter());
        }
        if (this.carBody.getCenter().getY() < -20.0) {
            Game.transitionToScene((Scene)new CarDemo());
        }
    }

    private static Actor createParticle(double size, Vector center, Color initialColor, Vector impulse) {
        Circle particle = new Circle(size);
        particle.setBodyType(BodyType.PARTICLE);
        particle.setLayerPosition(2);
        particle.setColor(initialColor);
        particle.setCenter(center);
        particle.animateParticle(Random.range((double)0.1, (double)3.0));
        particle.animateColor(Random.range((double)0.3, (double)0.6), Color.BLACK);
        particle.applyImpulse(impulse);
        particle.setGravityScale(1.0);
        particle.setLinearDamping((double)Random.range((int)18, (int)22));
        particle.setLayerPosition(-1);
        return particle;
    }

    private static Actor createSplitter(Vector center) {
        Polygon splitter = new Polygon(new Vector[]{Vector.vector((double)0.0, (double)0.0), Vector.vector((double)0.15, (double)0.0), Vector.vector((double)0.15, (double)0.05)});
        splitter.setBodyType(BodyType.PARTICLE);
        splitter.rotateBy((double)Random.range((int)0, (int)360));
        splitter.setLayerPosition(2);
        splitter.setColor(new Color(119, 82, 54));
        splitter.setCenter(center.add(Random.range((double)-0.2, (double)0.2), Random.range((double)-0.2, (double)0.2)));
        splitter.animateParticle(Random.range((double)0.1, (double)3.0));
        splitter.setGravityScale(1.0);
        splitter.setLinearDamping((double)Random.range((int)18, (int)22));
        splitter.setLayerPosition(-1);
        return splitter;
    }

    private static Runnable createSplitterEmitter(Actor actor) {
        return () -> {
            for (CollisionEvent collision : actor.getCollisions()) {
                if (!(collision.getColliding() instanceof Wood) || !(actor.getVelocity().getLength() > 1.0)) continue;
                for (Vector point : collision.getPoints()) {
                    Objects.requireNonNull(actor.getLayer()).add(new Actor[]{CarDemo.createSplitter(point)});
                }
            }
        };
    }

    public static void main(String[] args) {
        Game.start((int)1240, (int)812, (Scene)new CarDemo());
    }

    private static class Axle
    extends Rectangle
    implements FrameUpdateListener {
        private final PrismaticJoint spring;
        private final CarBody carBody;

        public Axle(double cx, double cy, CarBody carBody) {
            super(0.2, 0.9);
            this.setCenter(cx, cy);
            this.makeDynamic();
            this.setColor(new Color(255, 255, 255, 0));
            this.setDensity(50.0);
            this.carBody = carBody;
            this.spring = this.createPrismaticJoint((Actor)carBody, this.getCenterRelative().add(0.0, this.getHeight() / 2.0), 90.0);
            this.spring.setLimits(-0.15, 0.15);
            this.addMountListener(() -> Objects.requireNonNull(this.getLayer()).add(new Actor[]{carBody}));
        }

        public void onFrameUpdate(double pastTime) {
            double translation = this.spring.getTranslation();
            this.spring.setMotorSpeed(Math.sin(Math.min(Math.max(-0.15, translation), 0.15) / 0.15 * Math.PI / 2.0) * -0.3);
            this.spring.setMaximumMotorForce(5000.0);
        }

        public CarBody getCarBody() {
            return this.carBody;
        }
    }

    private static class CarBody
    extends Image {
        public CarBody(double cx, double cy) {
            super("car/truck-240px.png", 4.0, 1.2);
            this.setCenter(cx, cy);
            this.makeDynamic();
            this.setDensity(100.0);
            this.setAngularDamping(0.3);
            this.setFriction(0.5);
            this.setFixtures("R0,.45,2,.45&P2,1.2,2.6,1.15,3.8,0.8,3.95,0.45,2,0.45&R1,0,2,0.6");
            this.repeat(0.05, () -> {
                if (this.getVelocity().getLength() < 0.1) {
                    return;
                }
                for (CollisionEvent collision : this.getCollisions()) {
                    if (!(collision.getColliding() instanceof Mud)) continue;
                    for (Vector point : collision.getPoints()) {
                        double size = Random.range((double)0.05, (double)0.15);
                        Vector impulse = Vector.vector((double)Random.range((double)-1.0, (double)1.0), (double)Random.range((double)-1.0, (double)1.0));
                        Objects.requireNonNull(this.getLayer()).add(new Actor[]{CarDemo.createParticle(size, point, Color.YELLOW, impulse)});
                    }
                }
            });
            this.repeat(0.25, CarDemo.createSplitterEmitter((Actor)this));
        }
    }

    private static class Ground
    extends Rectangle
    implements Mud {
        public Ground(double startX, double endX) {
            super(endX - startX, 10.0);
            this.setPosition(startX, -20.0);
            this.setColor(GROUND_COLOR);
            this.makeStatic();
            this.setFriction(0.6);
            this.setElasticity(0.3);
            this.setDensity(150.0);
            this.setBorderRadius(0.1);
        }
    }

    private static class HillSegment
    extends Polygon
    implements Mud {
        public HillSegment(Vector ... vectors) {
            super(vectors);
        }
    }

    private static interface Mud {
        public Color getColor();
    }

    private static class RopeSegment
    extends Rectangle
    implements Wood {
        public RopeSegment(double width, double height) {
            super(width, height);
        }
    }

    private static class Wheel
    extends Image {
        private final RevoluteJoint motor;

        public Wheel(double cx, double cy, Axle axle) {
            super("car/wheel-back.png", 1.4, 1.4);
            this.setFixture(() -> FixtureBuilder.circle((double)0.7, (double)0.7, (double)0.7));
            this.setCenter(cx, cy);
            this.setDensity(100.0);
            this.makeDynamic();
            this.setFriction(0.5);
            this.setElasticity(0.2);
            this.setDensity(150.0);
            this.setAngularDamping(1.0);
            this.setLayerPosition(2);
            this.motor = this.createRevoluteJoint((Actor)axle, this.getCenterRelative());
            this.motor.setMaximumMotorTorque(5000.0);
            this.addMountListener(() -> Objects.requireNonNull(this.getLayer()).add(new Actor[]{axle}));
            this.addCollisionListener((Actor)axle.getCarBody(), CollisionEvent::ignoreCollision);
            this.repeat(0.025, () -> {
                for (CollisionEvent collision : this.getCollisions()) {
                    boolean slowMoving;
                    if (!(collision.getColliding() instanceof Mud)) continue;
                    double velocity = this.getVelocity().getLength();
                    double overTwist = Math.abs(this.getAngularVelocity() * Math.PI * 2.0 * 0.7) / velocity;
                    boolean bl = slowMoving = Math.abs(this.getVelocity().getX()) < 0.5 && Math.abs(this.getAngularVelocity()) < 0.3;
                    if (overTwist > 0.95 && overTwist < 1.05 || slowMoving) continue;
                    Vector impulse = collision.getTangentNormal().rotate(90.0).multiply(Math.min(Math.max(-1.0, overTwist - 1.0), 1.0));
                    for (Vector point : collision.getPoints()) {
                        double size = Random.range((double)0.05, (double)0.15);
                        Vector center = point.add(point.getDistance(this.getCenter()).multiply(size));
                        Color color = ((Mud)collision.getColliding()).getColor();
                        Objects.requireNonNull(this.getLayer()).add(new Actor[]{CarDemo.createParticle(size, center, color, impulse.rotate((double)Random.range((int)-15, (int)15)))});
                    }
                }
            });
            this.repeat(0.25, CarDemo.createSplitterEmitter((Actor)this));
        }

        public void setMotorSpeed(int speed) {
            this.motor.setMotorSpeed((double)speed);
        }

        public void setMotorEnabled(boolean enabled) {
            this.motor.setMotorEnabled(enabled);
        }
    }

    private static interface Wood {
    }
}

