/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude;

import de.pirckheimer_gymnasium.engine_pi.Bounds;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Layer;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.TileMap;
import de.pirckheimer_gymnasium.engine_pi.actor.TileRegistration;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.Coin;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.GameData;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.HUD;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.ManaPickup;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.PauseLayer;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.Platform;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.PlayerCharacter;

public class DudeDemo
extends Scene {
    public static final int WIDTH = 1240;
    public static final int HEIGHT = 812;
    private final GameData gameData = new GameData();
    private final PlayerCharacter character;

    public DudeDemo() {
        this.addLayer(new HUD(this.gameData));
        this.character = new PlayerCharacter(this.gameData);
        this.character.setPosition(0.0, 0.0);
        this.character.setRotationLocked(true);
        this.character.makeDynamic();
        this.add(new Actor[]{this.character});
        this.setGravity(new Vector(0.0, -13.0));
        this.getCamera().setFocus((Actor)this.character);
        this.getCamera().setOffset(new Vector(0.0, 3.0));
        this.getCamera().setBounds(new Bounds(-2000.0, -3.0, 20000.0, 20000.0));
        this.getCamera().setMeter(30.0);
        this.setupPlayground();
        this.setupCosmeticLayers();
        PauseLayer pauseLayer = new PauseLayer();
        pauseLayer.setVisible(false);
        this.addLayer(pauseLayer);
    }

    private void setupPlayground() {
        this.makePlatform(7, -7.0, -3.0);
        this.makePlatform(3, 3.0, 0.0);
        this.makePlatform(5, 13.0, -1.0);
        int i = 0;
        while (i < 15) {
            Coin coin = new Coin();
            coin.setPosition(6 + i, 6.0);
            coin.addCollisionListener((Actor)this.character, coin);
            this.add(new Actor[]{coin});
            ++i;
        }
        int j = 0;
        while (j < 30) {
            ManaPickup manaPickup = new ManaPickup();
            manaPickup.setPosition(-j, 1.0);
            manaPickup.addCollisionListener((Actor)this.character, manaPickup);
            this.add(new Actor[]{manaPickup});
            ++j;
        }
    }

    private void setupCosmeticLayers() {
        Layer middleBackground = new Layer();
        middleBackground.setParallaxPosition(0.1, 0.1);
        middleBackground.setLayerPosition(-200);
        Image backgroundImage = new Image("dude/background/snow.png", 25.0);
        backgroundImage.setPosition(-this.getVisibleArea(Game.getWindowSize()).width() / 2.0, -this.getVisibleArea(Game.getWindowSize()).height() / 2.0);
        middleBackground.add(new Actor[]{backgroundImage});
        Layer furtherBackground = new Layer();
        furtherBackground.setLayerPosition(-300);
        furtherBackground.setParallaxPosition(0.05, 0.05);
        Image moon = new Image("dude/moon.png", 1.0, 1.0);
        furtherBackground.add(new Actor[]{moon});
        moon.setPosition(300.0, 300.0);
        this.addLayer(middleBackground);
        this.addLayer(furtherBackground);
        this.addCloudLayer(10, "dude/tiles/sky/clouds_MG_1.png", 300, 1.6, 1.0, -100.0);
        this.addCloudLayer(10, "dude/tiles/sky/clouds_MG_2.png", -50, 0.8, 1.0, -100.0);
        this.addCloudLayer(10, "dude/tiles/sky/clouds_MG_3.png", -60, 0.7, 1.0, -100.0);
    }

    private void addCloudLayer(int NUM_TILES, String tilePath, int layerLevel, double xParallax, double yParallax, double xOffset) {
        Layer clouds = new Layer();
        clouds.setParallaxPosition(xParallax, yParallax);
        clouds.setLayerPosition(layerLevel);
        double SCALE = 0.08;
        TileRegistration cloudTiles = new TileRegistration(NUM_TILES, 1, 30.72, 17.28);
        int i = 0;
        while (i < NUM_TILES) {
            cloudTiles.setTile(i, 0, TileMap.createFromImage((String)tilePath));
            ++i;
        }
        cloudTiles.setPosition(xOffset, -this.getVisibleArea(Game.getWindowSize()).height() / 2.0 + 5.0);
        clouds.add(new Actor[]{cloudTiles});
        this.addLayer(clouds);
    }

    private void makePlatform(int length, double pX, double pY) {
        Platform platform = new Platform(length);
        platform.setPosition(pX, pY);
        this.add(new Actor[]{platform});
    }

    public static void main(String[] args) {
        Game.start((int)1240, (int)812, (Scene)new DudeDemo());
    }
}

