/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Polygon;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi_demos.ForceKlickEnvironment;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class JointDemo
extends ForceKlickEnvironment
implements KeyStrokeListener {
    private boolean schwerkraftActive = false;
    private Rectangle wippe;
    private Polygon basis;
    private Rectangle[] kette;
    private Circle ball;

    public JointDemo() {
        this.initialisieren2();
    }

    public void initialisieren2() {
        this.wippeBauen();
        this.ketteBauen(15);
        this.leashBauen();
        this.hoverHolderBauen();
        this.ball = new Circle(1.0);
        this.add(new Actor[]{this.ball});
        this.ball.setColor(Color.BLUE);
        this.ball.setPosition(new Vector(300.0, 200.0));
        this.ball.makeDynamic();
    }

    private void hoverHolderBauen() {
        int FACT = 2;
        Polygon halter = new Polygon(new Vector[]{new Vector(0.0, 100.0), new Vector(50.0, 150.0), new Vector(100.0, 150.0), new Vector(150.0, 100.0), new Vector(150.0, 200.0), new Vector(0.0, 200.0)});
        halter.setColor(Color.CYAN);
        halter.makeDynamic();
        Rectangle item = new Rectangle(70.0, 40.0);
        item.setPosition(60.0, 0.0);
        item.setColor(Color.red);
        item.makeDynamic();
        halter.createDistanceJoint((Actor)item, halter.getCenter(), item.getCenter());
    }

    private void leashBauen() {
        Circle kx = new Circle(30.0);
        kx.setColor(Color.BLUE);
        kx.makeDynamic();
        Circle ky = new Circle(50.0);
        ky.setPosition(50.0, 0.0);
        ky.setColor(Color.GREEN);
        ky.makeDynamic();
        kx.createRopeJoint((Actor)ky, new Vector(15.0, 15.0), new Vector(25.0, 25.0), 4.0);
    }

    private void wippeBauen() {
        this.basis = new Polygon(new Vector[]{new Vector(0.0, 100.0), new Vector(100.0, 100.0), new Vector(50.0, 0.0)});
        this.basis.makeStatic();
        this.basis.setColor(Color.WHITE);
        this.wippe = new Rectangle(500.0, 40.0);
        this.wippe.makeDynamic();
        this.wippe.setCenter(50.0, 0.0);
        this.wippe.setColor(Color.GRAY);
        Vector verzug = new Vector(100.0, 100.0);
        this.wippe.moveBy(verzug);
        this.basis.moveBy(verzug);
        this.wippe.createRevoluteJoint((Actor)this.basis, new Vector(50.0, 0.0).add(verzug));
    }

    private void ketteBauen(int kettenlaenge) {
        this.kette = new Rectangle[kettenlaenge];
        int i = 0;
        while (i < this.kette.length) {
            this.kette[i] = new Rectangle(50.0, 10.0);
            Vector posrel = new Vector((double)(45 * i), 30.0);
            this.kette[i].moveBy(posrel);
            this.kette[i].setColor(Color.GREEN);
            this.kette[i].setBodyType(i == 0 ? BodyType.STATIC : BodyType.DYNAMIC);
            if (i != 0) {
                this.kette[i - 1].createRevoluteJoint((Actor)this.kette[i], new Vector(0.0, 5.0).add(posrel));
            }
            ++i;
        }
        Circle gewicht = new Circle(100.0);
        gewicht.setColor(Color.WHITE);
        gewicht.makeDynamic();
        Vector vektor = new Vector((double)(45 * this.kette.length), 35.0);
        gewicht.setCenter(new Vector(vektor.getX(), vektor.getY()));
        gewicht.createRevoluteJoint((Actor)this.kette[this.kette.length - 1], vektor);
    }

    public void onKeyDown(KeyEvent e) {
        if (e.getKeyCode() == 83) {
            this.schwerkraftActive = !this.schwerkraftActive;
            this.setGravity(this.schwerkraftActive ? new Vector(0.0, 10.0) : Vector.NULL);
        }
    }

    public static void main(String[] args) {
        Game.start((int)1000, (int)800, (Scene)new JointDemo());
    }
}

