/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.collision;

import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi_demos.collision.Frog;
import de.pirckheimer_gymnasium.engine_pi_demos.collision.Platform;
import de.pirckheimer_gymnasium.engine_pi_demos.collision.SpikeBall;

public class FroggyJump
extends Scene {
    private Frog frog = new Frog();

    public FroggyJump() {
        this.add(new Actor[]{this.frog});
        this.setGravity(Vector.DOWN.multiply(10.0));
        Camera camera = this.getCamera();
        camera.setFocus((Actor)this.frog);
        camera.setOffset(new Vector(0.0, 4.0));
        this.makeLevel(40);
        this.makePlatforms(10);
    }

    private void makePlatforms(int heightLevel) {
        int i = 0;
        while (i < heightLevel) {
            Platform platform = new Platform(5.0, 1.0);
            platform.setPosition(0.0, i * 4);
            this.add(new Actor[]{platform});
            ++i;
        }
    }

    private void makeLevel(int heightLevel) {
        int i = 0;
        while (i < heightLevel) {
            int numPlatforms = Random.range((int)2) + 1;
            int j = 0;
            while (j < numPlatforms) {
                Platform platform = new Platform(6 / numPlatforms, 1.0);
                platform.setPosition((double)(numPlatforms * (j + 1) * i) * Random.range(), i * 4);
                this.add(new Actor[]{platform});
                ++j;
            }
            if (i > 3) {
                j = 0;
                while (j < Random.range((int)3)) {
                    SpikeBall.setupSpikeBall(Random.range() * (double)(4 + j) * (double)i, Random.range() * 4.0 + 0.5 + (double)(5 * i), this.getMainLayer());
                    ++j;
                }
            }
            ++i;
        }
    }
}

