/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.event;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.PeriodicTask;

public class PerodicTaskDemo
extends Scene {
    private PeriodicTask task;

    public PerodicTaskDemo() {
        this.setBackgroundColor("white");
        this.add(new Actor[]{new CounterText()});
    }

    public static void main(String[] args) {
        Game.start((int)400, (int)200, (Scene)new PerodicTaskDemo());
    }

    private class CounterText
    extends Text {
        private int counter;

        public CounterText() {
            super("0", 2.0);
            this.counter = 0;
            this.setCenter(0.0, 0.0);
            this.start();
            this.addKeyStrokeListener(e -> {
                if (e.getKeyCode() == 32) {
                    if (PerodicTaskDemo.this.task == null) {
                        this.start();
                    } else {
                        this.stop();
                    }
                } else if (e.getKeyCode() == 80) {
                    if (PerodicTaskDemo.this.task.isPaused) {
                        PerodicTaskDemo.this.task.resume();
                    } else {
                        PerodicTaskDemo.this.task.pause();
                    }
                }
            });
        }

        public void start() {
            PerodicTaskDemo.this.task = new PeriodicTask(0.1, () -> {
                ++this.counter;
                this.setContent(this.counter);
            });
            this.addFrameUpdateListener((FrameUpdateListener)PerodicTaskDemo.this.task);
        }

        public void stop() {
            PerodicTaskDemo.this.task.unregister();
            PerodicTaskDemo.this.task = null;
        }
    }
}

