/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.gameloop;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class SnakeMinimal
extends Scene {
    private Text scoreText = new Text("Score: 0", 1.4);
    private int score = 0;
    private Snake snake = new Snake();

    public SnakeMinimal() {
        this.add(new Actor[]{this.snake});
        this.scoreText.setPosition(-9.0, 5.0);
        this.add(new Actor[]{this.scoreText});
        this.placeRandomGoodie();
    }

    public void setScore(int score) {
        this.score = score;
        this.scoreText.setContent("Score: " + score);
    }

    public void increaseScore() {
        this.setScore(this.score + 1);
    }

    public void placeRandomGoodie() {
        double x = Random.range() * 10.0 - 5.0;
        double y = Random.range() * 10.0 - 5.0;
        Goodie goodie = new Goodie();
        goodie.setCenter(x, y);
        this.add(new Actor[]{goodie});
        goodie.addCollisionListener((Actor)this.snake, goodie);
    }

    public static void main(String[] args) {
        Game.start((int)600, (int)400, (Scene)new SnakeMinimal());
    }

    private class Goodie
    extends Text
    implements CollisionListener<Snake> {
        public Goodie() {
            super("Eat Me!", 1.0);
            this.setColor(Color.RED);
        }

        public void onCollision(CollisionEvent<Snake> collisionEvent) {
            SnakeMinimal.this.increaseScore();
            this.remove();
            SnakeMinimal.this.placeRandomGoodie();
        }
    }

    private class Snake
    extends Circle
    implements FrameUpdateListener,
    KeyStrokeListener {
        private Vector movement;

        public Snake() {
            super(1.0);
            this.movement = new Vector(0.0, 0.0);
            this.setColor(Color.GREEN);
        }

        public void onFrameUpdate(double timeInS) {
            this.moveBy(this.movement.multiply(timeInS));
        }

        public void onKeyDown(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 87: {
                    this.movement = new Vector(0.0, 5.0);
                    break;
                }
                case 65: {
                    this.movement = new Vector(-5.0, 0.0);
                    break;
                }
                case 83: {
                    this.movement = new Vector(0.0, -5.0);
                    break;
                }
                case 68: {
                    this.movement = new Vector(5.0, 0.0);
                }
            }
        }
    }
}

