/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import de.pirckheimer_gymnasium.engine_pi.sound.Jukebox;
import de.pirckheimer_gymnasium.engine_pi.sound.LoopedTrack;
import de.pirckheimer_gymnasium.engine_pi.sound.MusicPlayback;
import de.pirckheimer_gymnasium.engine_pi.sound.Playback;
import de.pirckheimer_gymnasium.engine_pi.sound.SinglePlayTrack;
import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import de.pirckheimer_gymnasium.engine_pi.sound.Track;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JukeboxDemo
extends Scene
implements KeyStrokeListener {
    Jukebox jukebox;
    Playback casinoBling;
    Track gameReached;
    Track gameBonus;
    Track levelMusic;

    public JukeboxDemo() throws IOException, UnsupportedAudioFileException {
        Game.start((int)200, (int)300, (Scene)this);
        this.jukebox = Game.getJukebox();
        this.casinoBling = this.jukebox.createPlayback("sounds/casino-bling-achievement.mp3", true);
        this.gameReached = this.loadSinglePlayTrack("game-bonus-reached.mp3");
        this.gameBonus = this.loadSinglePlayTrack("arcade-video-game-bonus.mp3");
        this.levelMusic = this.loadLoopedTrack("game-level-music.mp3");
    }

    public Sound loadSound(String fileName) throws IOException, UnsupportedAudioFileException {
        return new Sound(ResourceLoader.loadAsStream((String)("sounds/" + fileName)), fileName);
    }

    public Track loadSinglePlayTrack(String fileName) throws IOException, UnsupportedAudioFileException {
        return new SinglePlayTrack(this.loadSound(fileName));
    }

    public Track loadLoopedTrack(String fileName) throws IOException, UnsupportedAudioFileException {
        return new LoopedTrack(this.loadSound(fileName));
    }

    public void onKeyDown(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 49: {
                this.jukebox.playSound("sounds/casino-bling-achievement.mp3");
                break;
            }
            case 50: {
                this.jukebox.playMusic(this.gameReached, false, false);
                break;
            }
            case 51: {
                this.jukebox.playMusic(this.gameBonus, false, false);
                break;
            }
            case 52: {
                this.jukebox.playMusic(this.levelMusic, false, false);
                break;
            }
            case 53: {
                this.casinoBling.start();
                break;
            }
            case 54: {
                this.casinoBling.cancel();
                break;
            }
            case 521: {
                this.increaseVolume();
                break;
            }
            case 45: {
                this.decreaseVolume();
                break;
            }
            case 83: {
                this.jukebox.stopMusic();
                break;
            }
            case 76: {
                for (MusicPlayback playback : this.jukebox.getAllMusic()) {
                    System.out.println(playback);
                }
                break;
            }
        }
    }

    private void changeVolume(float diff) {
        MusicPlayback playback = this.jukebox.getMusic();
        if (playback != null) {
            playback.setVolume(this.jukebox.getMusic().getVolume() - 0.1f);
        }
    }

    private void increaseVolume() {
        this.changeVolume(0.1f);
    }

    private void decreaseVolume() {
        this.changeVolume(-0.1f);
    }

    public static void main(String[] args) throws IOException, UnsupportedAudioFileException {
        new JukeboxDemo();
    }
}

