/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.physics;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import java.awt.Color;

public class DominoesDemo
extends Scene
implements FrameUpdateListener,
MouseClickListener {
    private Rectangle ground;
    private Rectangle wall;
    private Circle ball;
    private Rectangle angle;

    public DominoesDemo() {
        this.setupBasicObjects();
        this.setupPhysics();
        this.setupAngle();
        this.makeDominoes(20, 0.4, 3.0);
    }

    private void setupBasicObjects() {
        this.ground = new Rectangle(200.0, 2.0);
        this.ground.setCenter(0.0, -5.0);
        this.ground.setColor(Color.WHITE);
        this.add(new Actor[]{this.ground});
        this.ball = new Circle(0.5);
        this.ball.setColor(Color.RED);
        this.ball.setPosition(-10.0, -2.0);
        this.add(new Actor[]{this.ball});
        this.wall = new Rectangle(1.0, 40.0);
        this.wall.setPosition(-14.0, -4.0);
        this.wall.setColor(Color.WHITE);
    }

    private void setupAngle() {
        this.angle = new Rectangle(1.0, 0.1);
        this.angle.setColor(Color.GREEN);
        this.add(new Actor[]{this.angle});
    }

    private void setupPhysics() {
        this.ground.makeStatic();
        this.wall.makeDynamic();
        this.ball.makeDynamic();
        this.setGravityOfEarth();
    }

    private void makeDominoes(int num, double width, double height) {
        for (int i = 0; i < num; ++i) {
            Rectangle domino = new Rectangle(width, height);
            domino.setPosition((double)(i * 3) * width, -4.0);
            domino.makeDynamic();
            domino.setColor(Color.BLUE);
            this.add(new Actor[]{domino});
        }
    }

    public void onFrameUpdate(double pastTime) {
        Vector mousePosition = this.getMousePosition();
        Vector ballCenter = this.ball.getCenter();
        Vector distance = ballCenter.getDistance(mousePosition);
        this.angle.setPosition(this.ball.getCenter());
        this.angle.setWidth(distance.getLength());
        double rot = Vector.RIGHT.getAngle(distance);
        this.angle.setRotation(rot);
    }

    public void onMouseDown(Vector position, MouseButton button) {
        Vector impulse = this.ball.getCenter().getDistance(position).multiply(5.0);
        this.ball.applyImpulse(impulse);
    }

    public static void main(String[] args) {
        Game.start((int)800, (int)300, (Scene)new DominoesDemo());
    }
}

