/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.physics.single_aspects;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import java.awt.event.KeyEvent;

public class DensityDemo
extends Scene
implements KeyStrokeListener {
    private final Rectangle ground;
    private final Circle[] circles = new Circle[3];
    private final Text[] densityLables = new Text[3];

    public DensityDemo() {
        int density = 10;
        int x = -5;
        for (int i = 0; i < 3; ++i) {
            this.circles[i] = this.createCircleWithDensity(x, density);
            this.densityLables[i] = this.createDensityLables(x, density);
            x += 5;
            density += 10;
        }
        this.setGravity(0.0, -9.81);
        this.ground = new Rectangle(20.0, 1.0);
        this.ground.setPosition(-10.0, -5.0);
        this.ground.makeStatic();
        this.add(new Actor[]{this.ground});
    }

    private Circle createCircleWithDensity(double x, double density) {
        Circle circle = new Circle(1.0);
        circle.setPosition(x, 5.0);
        circle.setDensity(density);
        circle.makeDynamic();
        this.add(new Actor[]{circle});
        return circle;
    }

    private Text createDensityLables(int x, int density) {
        Text text = new Text("" + density, 1.0);
        text.setPosition((double)x, -7.0);
        text.makeStatic();
        this.add(new Actor[]{text});
        return text;
    }

    public void onKeyDown(KeyEvent e) {
        for (Circle circle : this.circles) {
            circle.applyImpulse(0.0, 100.0);
        }
    }

    public static void main(String[] args) {
        Game.setDebug((boolean)true);
        Game.start((Scene)new DensityDemo());
    }
}

