/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Animation;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.StatefulAnimation;
import de.pirckheimer_gymnasium.engine_pi.animation.Interpolator;
import de.pirckheimer_gymnasium.engine_pi.animation.ValueAnimator;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.SinusDouble;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.GameData;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.Item;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.Platform;
import de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude.PlayerState;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.HashSet;

public class PlayerCharacter
extends StatefulAnimation<PlayerState>
implements CollisionListener<Actor>,
FrameUpdateListener,
KeyStrokeListener {
    private static final double MAX_SPEED = 100.0;
    public static final int JUMP_FORCE = 150;
    public static final int SMASH_FORCE = -1500;
    public static final int BOTTOM_OUT = -16;
    private static final int DOUBLE_JUMP_COST = 3;
    private static final int MANA_PICKUP_BONUS = 50;
    private static final int ROCKETCOST_PER_FRAME = 5;
    private static final boolean GOD_MODE = true;
    private static final double FRICTION = 0.5;
    private static final double RESTITUTION = 0.0;
    private boolean didDoubleJump = false;
    private boolean rocketMode = false;
    private final GameData gameData;
    private final Collection<Platform> ignoredPlatformForCollision = new HashSet<Platform>();
    private HorizontalMovement horizontalMovement = HorizontalMovement.IDLE;
    private Vector smashForce = Vector.NULL;

    public PlayerCharacter(GameData gameData) {
        super(1.0, 1.0);
        this.gameData = gameData;
        String basePath = "dude/char/spr_m_traveler_";
        this.addState((Object)PlayerState.Idle, Animation.createFromAnimatedGif((String)(basePath + "idle_anim.gif"), (double)1.0, (double)1.0));
        this.addState((Object)PlayerState.Walking, Animation.createFromAnimatedGif((String)(basePath + "walk_anim.gif"), (double)1.0, (double)1.0));
        this.addState((Object)PlayerState.Running, Animation.createFromAnimatedGif((String)(basePath + "run_anim.gif"), (double)1.0, (double)1.0));
        this.addState((Object)PlayerState.JumpingUp, Animation.createFromAnimatedGif((String)(basePath + "jump_1up_anim.gif"), (double)1.0, (double)1.0));
        this.addState((Object)PlayerState.Midair, Animation.createFromAnimatedGif((String)(basePath + "jump_2midair_anim.gif"), (double)1.0, (double)1.0));
        this.addState((Object)PlayerState.Falling, Animation.createFromAnimatedGif((String)(basePath + "jump_3down_anim.gif"), (double)1.0, (double)1.0));
        this.addState((Object)PlayerState.Landing, Animation.createFromAnimatedGif((String)(basePath + "jump_4land_anim.gif"), (double)1.0, (double)1.0));
        this.addState((Object)PlayerState.Smashing, Animation.createFromAnimatedGif((String)(basePath + "jump_4land_anim.gif"), (double)1.0, (double)1.0));
        this.setStateTransition((Object)PlayerState.Midair, (Object)PlayerState.Falling);
        this.setStateTransition((Object)PlayerState.Landing, (Object)PlayerState.Idle);
        this.setFriction(0.5);
        this.setElasticity(0.0);
        this.setFixtures("C0.5,0.3,0.3&C0.5,0.6,0.3");
        this.addCollisionListener(this);
    }

    public void tryJumping() {
        if (this.isGrounded()) {
            this.applyImpulse(new Vector(0.0, 150.0));
            this.setState((Object)PlayerState.JumpingUp);
        } else if (!this.didDoubleJump && this.gameData.getMana() >= 3 && !((PlayerState)((Object)this.getCurrentState())).equals("smashing")) {
            this.didDoubleJump = true;
            this.gameData.consumeMana(3);
            this.setVelocity(new Vector(this.getVelocity().getX(), 0.0));
            this.applyImpulse(new Vector(0.0, 120.0));
            this.setState((Object)PlayerState.JumpingUp);
        }
    }

    public void setHorizontalMovement(HorizontalMovement state) {
        switch (state) {
            case LEFT: {
                this.setFlipHorizontal(true);
                break;
            }
            case RIGHT: {
                this.setFlipHorizontal(false);
                break;
            }
        }
        this.horizontalMovement = state;
    }

    public HorizontalMovement getHorizontalMovement() {
        return this.horizontalMovement;
    }

    public void gotItem(Item item) {
        switch (item) {
            case Coin: {
                this.gameData.addMoney(1);
                break;
            }
            case ManaPickup: {
                this.gameData.addMana(50);
            }
        }
    }

    public void smash() {
        PlayerState currentState = (PlayerState)((Object)this.getCurrentState());
        if (currentState == PlayerState.Falling || currentState == PlayerState.JumpingUp || currentState == PlayerState.Midair) {
            this.setState((Object)PlayerState.Smashing);
            this.smashForce = new Vector(0.0, -1500.0);
        }
    }

    public void onFrameUpdate(double pastTime) {
        double impulse;
        Vector velocity = this.getVelocity();
        this.gameData.setPlayerVelocity(velocity.getLength());
        double desiredVelocity = this.horizontalMovement.getTargetXVelocity();
        if (desiredVelocity == 0.0) {
            impulse = 0.0;
            this.setVelocity(new Vector(velocity.getX() * 0.95, velocity.getY()));
        } else {
            impulse = (desiredVelocity - velocity.getX()) * 4.0;
            this.applyForce(new Vector(impulse, 0.0));
        }
        if (this.rocketMode) {
            if (this.gameData.getMana() <= 0) {
                // empty if block
            }
            this.gameData.consumeMana(5);
            this.applyImpulse(new Vector(0.0, 5.0));
            Circle particle = new Circle(0.1);
            particle.setPosition(this.getCenter().subtract(new Vector(Math.random() * 0.1, 0.45)));
            particle.setColor(Color.RED);
            particle.setLayerPosition(-1);
            particle.animateParticle(0.5);
            particle.animateColor(0.25, Color.YELLOW);
            particle.applyImpulse(new Vector(0.005 * -impulse + (Math.random() - 0.5), -2.0 * Math.random()));
            particle.addCollisionListener(e -> {
                Platform platform;
                if (e.getColliding() instanceof Platform && this.ignoredPlatformForCollision.contains((Object)(platform = (Platform)e.getColliding()))) {
                    e.ignoreCollision();
                }
            });
            this.getLayer().add(new Actor[]{particle});
        }
        switch ((PlayerState)((Object)this.getCurrentState())) {
            case JumpingUp: {
                if (!(velocity.getY() < 0.0)) break;
                this.setState((Object)PlayerState.Midair);
                break;
            }
            case Idle: 
            case Running: 
            case Walking: {
                this.didDoubleJump = false;
                if (velocity.getY() > 0.1) {
                    this.setState((Object)PlayerState.Midair);
                    break;
                }
                if (Math.abs(velocity.getX()) > 5.5) {
                    this.changeState((Object)PlayerState.Running);
                    break;
                }
                if (Math.abs(velocity.getX()) > 0.1) {
                    this.changeState((Object)PlayerState.Walking);
                    break;
                }
                this.changeState((Object)PlayerState.Idle);
                break;
            }
        }
        this.applyForce(this.smashForce);
        if (this.getY() < -16.0) {
            this.resetMovement();
            this.setPosition(0.0, 0.0);
            this.setState((Object)PlayerState.Falling);
        }
    }

    public void onKeyDown(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 65: {
                if (this.horizontalMovement == HorizontalMovement.RIGHT) break;
                this.setHorizontalMovement(HorizontalMovement.LEFT);
                break;
            }
            case 83: {
                this.smash();
                break;
            }
            case 68: {
                if (this.getHorizontalMovement() == HorizontalMovement.LEFT) break;
                this.setHorizontalMovement(HorizontalMovement.RIGHT);
                break;
            }
            case 32: 
            case 87: {
                this.tryJumping();
                break;
            }
            case 16: {
                this.rocketMode = true;
            }
        }
    }

    public void onKeyUp(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 65: {
                if (this.horizontalMovement != HorizontalMovement.LEFT) break;
                if (Game.isKeyPressed((int)68)) {
                    this.setHorizontalMovement(HorizontalMovement.RIGHT);
                    break;
                }
                this.setHorizontalMovement(HorizontalMovement.IDLE);
                break;
            }
            case 68: {
                if (this.getHorizontalMovement() != HorizontalMovement.RIGHT) break;
                if (Game.isKeyPressed((int)65)) {
                    this.setHorizontalMovement(HorizontalMovement.LEFT);
                    break;
                }
                this.setHorizontalMovement(HorizontalMovement.IDLE);
                break;
            }
            case 16: {
                this.rocketMode = false;
            }
        }
    }

    public void onCollision(CollisionEvent<Actor> collisionEvent) {
        boolean smashing;
        if (collisionEvent.getColliding() instanceof Platform) {
            Platform platform = (Platform)collisionEvent.getColliding();
            if (this.getVelocity().getY() > 0.0 || this.ignoredPlatformForCollision.contains((Object)platform)) {
                this.ignoredPlatformForCollision.add(platform);
                collisionEvent.ignoreCollision();
            }
        }
        boolean falling = this.getCurrentState() == PlayerState.Falling;
        boolean bl = smashing = this.getCurrentState() == PlayerState.Smashing;
        if ((falling || smashing) && this.isGrounded()) {
            Vector speed;
            this.setState((Object)PlayerState.Landing);
            this.smashForce = Vector.NULL;
            if (smashing) {
                Vector originalOffset = this.getLayer().getParent().getCamera().getOffset();
                SinusDouble interpolator = new SinusDouble(0.0, -4.0E-4 * this.getVelocity().getY());
                ValueAnimator valueAnimator = new ValueAnimator(0.1, y -> this.getLayer().getParent().getCamera().setOffset(originalOffset.add(new Vector(0.0, y.doubleValue()))), (Interpolator)interpolator, (FrameUpdateListenerRegistration)this.getLayer());
                this.getLayer().addFrameUpdateListener((FrameUpdateListener)valueAnimator);
                valueAnimator.addCompletionListener(value -> this.getLayer().getFrameUpdateListeners().remove((Object)valueAnimator));
            }
            Vector transformedSpeed = Math.abs((speed = this.getPhysicsHandler().getVelocity()).getX()) < 0.1 ? speed.add(100.0 * (Math.random() - 0.5), 0.0) : speed;
            for (int i = 0; i < 100; ++i) {
                Circle particle = new Circle(Random.range() * 0.02 + 0.02);
                particle.setPosition(this.getCenter().add(0.0, -32.0));
                particle.applyImpulse(transformedSpeed.negate().multiply(Math.random() * 0.1).multiplyY(Math.random() * 0.1));
                particle.setColor(Color.GRAY);
                particle.setLayerPosition(-1);
                particle.animateParticle(0.5);
                this.getLayer().add(new Actor[]{particle});
            }
        }
    }

    public void onCollisionEnd(CollisionEvent<Actor> collisionEvent) {
        if (collisionEvent.getColliding() instanceof Platform) {
            Platform platform = (Platform)collisionEvent.getColliding();
            this.ignoredPlatformForCollision.remove((Object)platform);
        }
    }

    private static enum HorizontalMovement {
        LEFT(-100.0),
        RIGHT(100.0),
        IDLE(0.0);

        private final double targetVelocityX;

        private HorizontalMovement(double targetVelocityX) {
            this.targetVelocityX = targetVelocityX;
        }

        public double getTargetXVelocity() {
            return this.targetVelocityX;
        }
    }
}

