/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.collision;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Layer;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi_demos.collision.Frog;
import de.pirckheimer_gymnasium.engine_pi_demos.collision.FroggyJump;

class SpikeBall
extends Image
implements CollisionListener<Frog> {
    public SpikeBall() {
        super("froggy/Spiked-Ball.png", 40.0);
        this.setGravityScale(0.0);
        this.addCollisionListener(Frog.class, this);
    }

    public static SpikeBall setupSpikeBall(double x, double y, Layer layer) {
        SpikeBall ball = new SpikeBall();
        ball.setCenter(x, y);
        SpikeSensor sensor = new SpikeSensor(ball);
        sensor.setPosition(x - 1.0, y - 8.0);
        layer.add(new Actor[]{ball, sensor});
        return ball;
    }

    public void onCollision(CollisionEvent<Frog> collisionEvent) {
        ((Frog)collisionEvent.getColliding()).kill();
    }

    public static void main(String[] args) {
        Game.start((int)400, (int)600, (Scene)new FroggyJump());
    }

    private static class SpikeSensor
    extends Rectangle
    implements CollisionListener<Frog> {
        private SpikeBall ball;

        public SpikeSensor(SpikeBall ball) {
            super(2.0, 8.0);
            this.ball = ball;
            this.setVisible(false);
            this.makeSensor();
            this.addCollisionListener(Frog.class, this);
            this.setGravityScale(0.0);
        }

        public void onCollision(CollisionEvent<Frog> collisionEvent) {
            this.ball.setGravityScale(1.0);
        }
    }
}

