/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.stateful_animation;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Animation;
import de.pirckheimer_gymnasium.engine_pi.actor.StatefulAnimation;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi_demos.stateful_animation.PlayerState;
import java.awt.event.KeyEvent;

public class StatefulPlayerCharacter
extends StatefulAnimation<PlayerState>
implements KeyStrokeListener,
FrameUpdateListener {
    private static final double THRESHOLD = 0.01;
    private static final double RUNNING_THRESHOLD = 10.0;
    private static final double WALKING_THRESHOLD = 1.0;
    private static final Float MAX_SPEED = Float.valueOf(20.0f);
    private static final double FORCE = 16000.0;
    private static final double JUMP_IMPULSE = 1100.0;

    public StatefulPlayerCharacter() {
        super(3.0, 3.0);
        this.setupPlayerStates();
        this.setupAutomaticTransitions();
        this.setupPhysics();
    }

    private void setupPlayerStates() {
        for (PlayerState state : PlayerState.values()) {
            Animation animationOfState = Animation.createFromAnimatedGif((String)state.getGifFileLocation(), (double)3.0, (double)3.0);
            this.addState((Object)state, animationOfState);
        }
    }

    private void setupAutomaticTransitions() {
        this.setStateTransition((Object)PlayerState.MIDAIR, (Object)PlayerState.FALLING);
        this.setStateTransition((Object)PlayerState.LANDING, (Object)PlayerState.IDLE);
    }

    private void setupPhysics() {
        this.makeDynamic();
        this.setRotationLocked(true);
        this.setElasticity(0.0);
        this.setFriction(30.0);
        this.setLinearDamping(0.3);
    }

    public void onKeyDown(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 32: {
                this.attemptJump();
            }
        }
    }

    private void attemptJump() {
        PlayerState state = (PlayerState)((Object)this.getCurrentState());
        if ((state == PlayerState.IDLE || state == PlayerState.WALKING || state == PlayerState.RUNNING) && this.isGrounded()) {
            this.applyImpulse(new Vector(0.0, 1100.0));
            this.setState((Object)PlayerState.JUMPING);
        }
    }

    public void onFrameUpdate(double dT) {
        Vector velocity = this.getVelocity();
        PlayerState state = (PlayerState)((Object)this.getCurrentState());
        if (velocity.getY() < -0.01) {
            switch (state) {
                case JUMPING: {
                    this.setState((Object)PlayerState.MIDAIR);
                    break;
                }
                case IDLE: 
                case WALKING: 
                case RUNNING: {
                    this.setState((Object)PlayerState.FALLING);
                    break;
                }
            }
        } else if (velocity.getY() < 0.01 && state == PlayerState.FALLING) {
            this.setState((Object)PlayerState.LANDING);
        }
        if (Math.abs(velocity.getX()) > (double)MAX_SPEED.floatValue()) {
            this.setVelocity(new Vector(Math.signum(velocity.getX()) * (double)MAX_SPEED.floatValue(), velocity.getY()));
        }
        if (Game.isKeyPressed((int)65)) {
            this.applyForce(new Vector(-16000.0, 0.0));
        } else if (Game.isKeyPressed((int)68)) {
            this.applyForce(new Vector(16000.0, 0.0));
        }
        if (state == PlayerState.IDLE || state == PlayerState.WALKING || state == PlayerState.RUNNING) {
            double velXTotal = Math.abs(velocity.getX());
            if (velXTotal > 10.0) {
                this.changeState((Object)PlayerState.RUNNING);
            } else if (velXTotal > 1.0) {
                this.changeState((Object)PlayerState.WALKING);
            } else {
                this.changeState((Object)PlayerState.IDLE);
            }
        }
        if (velocity.getX() > 0.0) {
            this.setFlipHorizontal(false);
        } else if (velocity.getX() < 0.0) {
            this.setFlipHorizontal(true);
        }
    }
}

