/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.billard;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi_demos.billard.Ball;
import de.pirckheimer_gymnasium.engine_pi_demos.billard.Table;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class BillardDemo
extends Scene
implements KeyStrokeListener {
    private static final int WIDTH = 1240;
    private static final int HEIGHT = 812;
    private final Ball whiteBall;

    public BillardDemo() {
        Table table = new Table();
        this.add(table.getActors());
        for (int i = 0; i < 10; ++i) {
            Ball ball = new Ball();
            ball.setPosition(this.calculatePosition(i));
            this.add(new Actor[]{ball});
        }
        this.whiteBall = new Ball();
        this.whiteBall.setColor(Color.WHITE);
        this.whiteBall.setPosition(-200.0, 0.0);
        this.add(new Actor[]{this.whiteBall});
        this.getCamera().setFocus((Actor)table.getBorder());
        this.getCamera().setMeter(1.0);
    }

    private Vector calculatePosition(int i) {
        switch (i) {
            case 0: {
                return new Vector(0.0, 0.0);
            }
            case 1: {
                return new Vector(24.0, 12.0);
            }
            case 2: {
                return new Vector(24.0, -12.0);
            }
            case 3: {
                return new Vector(48.0, 24.0);
            }
            case 4: {
                return new Vector(48.0, 0.0);
            }
            case 5: {
                return new Vector(48.0, -24.0);
            }
            case 6: {
                return new Vector(72.0, 24.0);
            }
            case 7: {
                return new Vector(72.0, 12.0);
            }
            case 8: {
                return new Vector(72.0, -12.0);
            }
            case 9: {
                return new Vector(72.0, -24.0);
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    public void onKeyDown(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.whiteBall.applyImpulse(new Vector(1.0E9, (Random.range() - 0.5) * 2.0));
        }
    }

    public static void main(String[] args) {
        Game.start((int)1240, (int)812, (Scene)new BillardDemo());
    }
}

