/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.billard;

import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi_demos.billard.Ball;
import de.pirckheimer_gymnasium.engine_pi_demos.billard.Edge;
import de.pirckheimer_gymnasium.engine_pi_demos.billard.Hole;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class Table {
    public static final double BORDER = 30.0;
    public static final double GAP = 20.0;
    public static final double DIAGONAL_GAP = Math.sqrt(200.0) * 2.0;
    private final List<Actor> actors = new ArrayList<Actor>();
    private Rectangle border = new Rectangle(1040.0 + 2.0 * DIAGONAL_GAP + 60.0, 500.0 + 2.0 * DIAGONAL_GAP + 60.0);

    public Table() {
        this.border.setPosition(-520.0 - DIAGONAL_GAP - 30.0, -250.0 - DIAGONAL_GAP - 30.0);
        this.border.setColor(new Color(226, 228, 231));
        Rectangle background = new Rectangle(1040.0 + 2.0 * DIAGONAL_GAP, 500.0 + 2.0 * DIAGONAL_GAP);
        background.setPosition(-520.0 - DIAGONAL_GAP, -250.0 - DIAGONAL_GAP);
        background.setColor(new Color(68, 121, 43));
        this.actors.add((Actor)this.border);
        this.actors.add((Actor)background);
        this.createEdges();
        this.createHoles();
    }

    public Actor[] getActors() {
        return this.actors.toArray(new Actor[0]);
    }

    public Rectangle getBorder() {
        return this.border;
    }

    private void createHoles() {
        CollisionListener collisionListener = collisionEvent -> {
            if (collisionEvent.getColliding() instanceof Ball) {
                collisionEvent.getColliding().remove();
            }
        };
        Hole hole = new Hole(-520.0 - DIAGONAL_GAP - 10.0, 210.0 + DIAGONAL_GAP + 10.0);
        hole.addCollisionListener(collisionListener);
        this.actors.add((Actor)hole);
        hole = new Hole(-20.0, 210.0 + DIAGONAL_GAP + 20.0);
        hole.addCollisionListener(collisionListener);
        this.actors.add((Actor)hole);
        hole = new Hole(520.0 + DIAGONAL_GAP - 40.0 + 10.0, 210.0 + DIAGONAL_GAP + 10.0);
        hole.addCollisionListener(collisionListener);
        this.actors.add((Actor)hole);
        hole = new Hole(-520.0 - DIAGONAL_GAP - 10.0, -250.0 - DIAGONAL_GAP - 10.0);
        hole.addCollisionListener(collisionListener);
        this.actors.add((Actor)hole);
        hole = new Hole(-20.0, -250.0 - DIAGONAL_GAP - 20.0);
        hole.addCollisionListener(collisionListener);
        this.actors.add((Actor)hole);
        hole = new Hole(520.0 + DIAGONAL_GAP - 40.0 + 10.0, -250.0 - DIAGONAL_GAP - 10.0);
        hole.addCollisionListener(collisionListener);
        this.actors.add((Actor)hole);
    }

    private void createEdges() {
        Edge topLeft = new Edge(-20.0, 250.0 + DIAGONAL_GAP);
        topLeft.rotateBy(180.0);
        this.actors.add((Actor)topLeft);
        Edge topRight = new Edge(520.0, 250.0 + DIAGONAL_GAP);
        topRight.rotateBy(180.0);
        this.actors.add((Actor)topRight);
        Edge bottomLeft = new Edge(-520.0, -250.0 - DIAGONAL_GAP);
        this.actors.add((Actor)bottomLeft);
        Edge bottomRight = new Edge(20.0, -250.0 - DIAGONAL_GAP);
        this.actors.add((Actor)bottomRight);
        Edge left = new Edge(-520.0 - DIAGONAL_GAP, 250.0);
        left.rotateBy(-90.0);
        this.actors.add((Actor)left);
        Edge right = new Edge(520.0 + DIAGONAL_GAP, -250.0);
        right.rotateBy(90.0);
        this.actors.add((Actor)right);
    }
}

