/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.gameloop;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import java.awt.Color;

public class SnakeAdvanced
extends Scene
implements FrameUpdateListener {
    private Text scoreText = new Text("Score: 0", 1.4);
    private int score = 0;
    private Snake snakeHead = new Snake();
    private double snake_speed = 5.0;
    private boolean makeNewHead = false;

    public SnakeAdvanced() {
        this.add(new Actor[]{this.snakeHead});
        this.scoreText.setPosition(-9.0, 5.0);
        this.add(new Actor[]{this.scoreText});
        this.placeRandomGoodie();
    }

    public void setScore(int score) {
        this.score = score;
        this.snake_speed = 5.0 + (double)score * 0.1;
        this.scoreText.setContent("Score: " + score);
    }

    public void increaseScore() {
        this.setScore(this.score + 1);
    }

    public void placeRandomGoodie() {
        double x = Random.range() * 10.0 - 5.0;
        double y = Random.range() * 10.0 - 5.0;
        Goodie goodie = new Goodie();
        goodie.setCenter(x, y);
        this.add(new Actor[]{goodie});
        goodie.addCollisionListener((Actor)this.snakeHead, goodie);
    }

    public void onFrameUpdate(double timeInS) {
        double dX = 0.0;
        double dY = 0.0;
        if (Game.isKeyPressed((int)87)) {
            dY = this.snake_speed * timeInS;
        }
        if (Game.isKeyPressed((int)65)) {
            dX = -this.snake_speed * timeInS;
        }
        if (Game.isKeyPressed((int)83)) {
            dY = -this.snake_speed * timeInS;
        }
        if (Game.isKeyPressed((int)68)) {
            dX = this.snake_speed * timeInS;
        }
        if (this.makeNewHead) {
            Snake newHead = new Snake();
            newHead.setCenter(this.snakeHead.getCenter());
            newHead.next = this.snakeHead;
            newHead.moveBy(new Vector(dX, dY).multiply(1.0));
            this.add(new Actor[]{newHead});
            this.snakeHead = newHead;
            this.makeNewHead = false;
        } else if (dX != 0.0 || dY != 0.0) {
            this.snakeHead.snakeHeadMove(dX, dY);
        }
    }

    public static void main(String[] args) {
        Game.start((int)600, (int)400, (Scene)new SnakeAdvanced());
    }

    private class Snake
    extends Circle {
        private Snake next;

        public Snake() {
            super(1.0);
            this.next = null;
            this.setColor(Color.GREEN);
        }

        private void snakeHeadMove(double dX, double dY) {
            Vector mycenter = this.getCenter();
            this.moveBy(dX, dY);
            if (this.next != null) {
                this.next.snakeChildrenMove(mycenter);
            }
        }

        private void snakeChildrenMove(Vector newCenter) {
            Vector mycenter = this.getCenter();
            this.setCenter(newCenter);
            if (this.next != null) {
                this.next.snakeChildrenMove(mycenter);
            }
        }
    }

    private class Goodie
    extends Text
    implements CollisionListener<Snake> {
        public Goodie() {
            super("Eat Me!", 1.0);
            this.setColor(Color.RED);
        }

        public void onCollision(CollisionEvent<Snake> collisionEvent) {
            SnakeAdvanced.this.increaseScore();
            SnakeAdvanced.this.makeNewHead = true;
            this.remove();
            SnakeAdvanced.this.placeRandomGoodie();
        }
    }
}

