/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.small_games.dude;

import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Tile;
import de.pirckheimer_gymnasium.engine_pi.actor.TileMap;
import de.pirckheimer_gymnasium.engine_pi.actor.TileRegistration;
import java.util.Arrays;
import java.util.List;

public class HUDDisplay {
    private static final int VALUE_LENGTH = 10;
    private static final double SCALE = 1.5;
    private final TileRegistration background;
    private final TileRegistration lines;
    private final TileMap[] lineSources = new TileMap[]{TileMap.createFromImage((String)"dude/hud/orb_red.png", (int)8, (int)16), TileMap.createFromImage((String)"dude/hud/orb_blue.png", (int)8, (int)16), TileMap.createFromImage((String)"dude/hud/orb_green.png", (int)8, (int)16)};
    private static final Tile TILE_BACK = TileMap.createFromImage((String)"dude/hud/back.png");
    private static final TileMap NUM_BLACK = TileMap.createFromImage((String)"dude/hud/num_black.png", (int)8, (int)16);
    private static final TileMap ORB_ORANGE = TileMap.createFromImage((String)"dude/hud/orb_orange.png", (int)8, (int)16);

    public HUDDisplay(double x, double y) {
        this.background = new TileRegistration(17, 4, 12.0, 24.0);
        for (int i = 0; i < 4; ++i) {
            this.background.setTile(0, i, ORB_ORANGE.getTile(0, 0));
            this.background.setTile(1, i, ORB_ORANGE.getTile(1, 0));
            this.background.setTile(4, i, ORB_ORANGE.getTile(1, 0));
            for (int j = 0; j < 10; ++j) {
                this.background.setTile(5 + j, i, TILE_BACK);
            }
            this.background.setTile(15, i, ORB_ORANGE.getTile(1, 0));
            this.background.setTile(16, i, ORB_ORANGE.getTile(2, 0));
        }
        this.background.setTile(2, 0, NUM_BLACK.getTile(6, 2));
        this.background.setTile(3, 0, NUM_BLACK.getTile(7, 2));
        this.background.setTile(2, 1, NUM_BLACK.getTile(8, 2));
        this.background.setTile(3, 1, NUM_BLACK.getTile(9, 2));
        this.background.setTile(2, 2, NUM_BLACK.getTile(4, 2));
        this.background.setTile(3, 2, NUM_BLACK.getTile(5, 2));
        this.background.setTile(2, 3, NUM_BLACK.getTile(2, 2));
        this.background.setTile(3, 3, NUM_BLACK.getTile(3, 2));
        this.lines = new TileRegistration(10, 4, 12.0, 24.0);
        this.background.setPosition(x, y);
        this.lines.setPosition(x, y);
        this.lines.moveBy(60.0, 0.0);
        this.setLineValue(0, 10, true);
        this.setLineValue(1, 0, false);
        this.setLineValue(2, 0, false);
        for (int k = 0; k < 5; ++k) {
            this.setNumberOf(k, 0);
        }
    }

    private void setNumberOf(int numIndex, int numValue) {
        if (numValue < 0 || numValue > 9) {
            return;
        }
        int x = numValue % 5 * 2;
        int y = numValue / 5;
        this.lines.setTile(numIndex * 2, 3, NUM_BLACK.getTile(x, y));
        this.lines.setTile(numIndex * 2 + 1, 3, NUM_BLACK.getTile(x + 1, y));
    }

    private void setLineValue(int lineIndex, int lineValue, boolean fullCapFinal) {
        for (int i = 0; i < 10; ++i) {
            if (i + 1 < lineValue) {
                this.lines.setTile(i, lineIndex, this.lineSources[lineIndex].getTile(1, 0));
                continue;
            }
            if (i + 1 == lineValue) {
                if (fullCapFinal) {
                    this.lines.setTile(i, lineIndex, this.lineSources[lineIndex].getTile(1, 0));
                    continue;
                }
                this.lines.setTile(i, lineIndex, this.lineSources[lineIndex].getTile(2, 0));
                continue;
            }
            this.lines.setTile(i, lineIndex, null);
        }
    }

    public void setLineDisplay(int lineNo, double rel) {
        if (lineNo < 0 || lineNo > 2 || rel < 0.0 || rel > 1.0) {
            return;
        }
        int doublePrecision = (int)(rel * 22.0);
        this.setLineValue(lineNo, doublePrecision / 2, doublePrecision % 2 == 1);
    }

    public void setDisplayNumber(int value) {
        for (int z = 1; z <= 5; ++z) {
            int baseValue = value % 10;
            this.setNumberOf(5 - z, baseValue);
            value /= 10;
        }
    }

    public List<Actor> getActors() {
        return Arrays.asList(this.background, this.lines);
    }
}

