/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.input.mouse;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.MouseButton;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import java.awt.Color;

public class PaintingCirclesAdvancedDemo
extends Scene
implements MouseClickListener {
    static Color activeColor = Color.WHITE;
    static double activeDiameter = 1.0;

    public PaintingCirclesAdvancedDemo() {
        this.addMouseClickListener(this);
        ColorRect white = new ColorRect(Color.WHITE);
        ColorRect blue = new ColorRect(Color.BLUE);
        ColorRect redPurple = new ColorRect(Color.PINK);
        ColorRect orange = new ColorRect(Color.ORANGE);
        white.setPosition(-8.0, 5.0);
        blue.setPosition(-6.0, 5.0);
        redPurple.setPosition(-4.0, 5.0);
        orange.setPosition(-2.0, 5.0);
        this.add(new Actor[]{white, blue, redPurple, orange});
        SizeText sizeText1 = new SizeText(1.0);
        SizeText sizeText2 = new SizeText(2.0);
        SizeText sizeText3 = new SizeText(3.0);
        sizeText1.setPosition(0.0, 5.0);
        sizeText2.setPosition(2.0, 5.0);
        sizeText3.setPosition(4.0, 5.0);
        this.add(new Actor[]{sizeText1, sizeText2, sizeText3});
    }

    private void paintCircleAt(double mX, double mY, double diameter, Color color) {
        Circle circle = new Circle(diameter);
        circle.setCenter(mX, mY);
        circle.setColor(color);
        this.add(new Actor[]{circle});
    }

    public void onMouseDown(Vector position, MouseButton mouseButton) {
        if (position.getY() < 5.0) {
            this.paintCircleAt(position.getX(), position.getY(), activeDiameter, activeColor);
        }
    }

    public static void main(String[] args) {
        Game.start((Scene)new PaintingCirclesAdvancedDemo(), (int)600, (int)400);
    }

    private static class ColorRect
    extends Rectangle
    implements MouseClickListener {
        private final Color color;

        public ColorRect(Color color) {
            super(1.0, 1.0);
            this.color = color;
            this.setColor(color);
        }

        public void onMouseDown(Vector position, MouseButton mouseButton) {
            if (this.contains(position)) {
                activeColor = this.color;
            }
        }
    }

    private class SizeText
    extends Text
    implements MouseClickListener {
        private final double diameter;

        public SizeText(double diameter) {
            super("" + diameter, 1.0);
            this.diameter = diameter;
            this.setColor(Color.CYAN);
        }

        public void onMouseDown(Vector position, MouseButton mouseButton) {
            if (this.contains(position)) {
                activeDiameter = this.diameter;
            }
        }
    }
}

