/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos.resources;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Polygon;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.resources.ColorScheme;
import de.pirckheimer_gymnasium.engine_pi.resources.ColorSchemeSelection;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class ColorWheelIttenDemo
extends Scene
implements KeyStrokeListener {
    private final int NUMBER_SEGMENTS = 12;
    private final double SEGMENT_ANGLE = 30.0;
    private final double INNER_RADIUS = 5.0;
    private final Actor[] WHEEL_AREAS;
    private final Actor[] PRIMARY_AREAS;
    private final Actor[] SECONDARY_AREAS;
    private final Actor[] EXTRA_AREAS;
    private final ColorSchemeSelection[] COLOR_SCHEMES = ColorSchemeSelection.values();
    private int currentColorScheme = -1;
    private final Text NAME;

    public ColorWheelIttenDemo() {
        this.WHEEL_AREAS = this.drawWheelColors();
        this.PRIMARY_AREAS = this.drawPrimaryColors();
        this.SECONDARY_AREAS = this.drawSecondaryColors();
        this.EXTRA_AREAS = this.drawExtraColors();
        this.NAME = this.addText("", -8.0, 7.0);
        this.NAME.setColor("white");
        this.setNextColorScheme();
        this.setBackgroundColor("#444444");
    }

    private Vector getCirclePoint(double radius, double angle) {
        return Vector.ofAngle((double)angle).multiply(radius);
    }

    private Actor createWheelArea(int index, double angle) {
        double HALF_SEGMENT_ANGLE = 15.0;
        double start = angle - HALF_SEGMENT_ANGLE;
        double end = angle + HALF_SEGMENT_ANGLE;
        double OUTER_RADIUS = 7.0;
        Polygon polygon = new Polygon(new Vector[]{this.getCirclePoint(OUTER_RADIUS, start), this.getCirclePoint(5.0, start), this.getCirclePoint(5.0, end), this.getCirclePoint(OUTER_RADIUS, end)});
        this.add(new Actor[]{polygon});
        return polygon;
    }

    private Actor[] drawWheelColors() {
        Actor[] areas = new Actor[12];
        for (int i = 0; i < 12; ++i) {
            double angle = (double)i * 30.0 * -1.0 + 90.0;
            Vector textPosition = this.getCirclePoint(7.5, angle);
            this.addText("" + i, 0.5, textPosition.getX(), textPosition.getY()).setColor("wei\u00df");
            areas[i] = this.createWheelArea(i, angle);
        }
        return areas;
    }

    private Actor[] drawSecondaryColors() {
        Actor[] areas = new Actor[3];
        int START_ANGLE = 90;
        for (int i = 0; i < 12; i += 4) {
            double radius = 4.8;
            int angle = START_ANGLE - i * 30;
            Polygon area = new Polygon(new Vector[]{this.getCirclePoint(radius, angle), this.getCirclePoint(radius, angle - 60), this.getCirclePoint(radius, angle - 120)});
            this.add(new Actor[]{area});
            areas[i / 4] = area;
        }
        return areas;
    }

    private Actor[] drawPrimaryColors() {
        Actor[] areas = new Actor[3];
        int START_ANGLE = 90;
        for (int i = 0; i < 12; i += 4) {
            double radius = 4.8;
            int angle = START_ANGLE - i * 30;
            Polygon area = new Polygon(new Vector[]{this.getCirclePoint(radius, angle + 60), this.getCirclePoint(radius, angle), this.getCirclePoint(radius, angle - 60), new Vector(0.0, 0.0)});
            this.add(new Actor[]{area});
            areas[i / 4] = area;
        }
        return areas;
    }

    private Actor[] drawExtraColors() {
        Actor[] areas = new Actor[4];
        for (int i = 0; i < 4; ++i) {
            areas[i] = this.addRectangle(7, -i - 5);
        }
        return areas;
    }

    private ColorSchemeSelection getNextColorScheme() {
        ++this.currentColorScheme;
        if (this.currentColorScheme >= this.COLOR_SCHEMES.length) {
            this.currentColorScheme = 0;
        }
        return this.COLOR_SCHEMES[this.currentColorScheme];
    }

    private void setColorScheme(ColorSchemeSelection selection) {
        this.NAME.setContent(selection.name());
        ColorScheme scheme = selection.getScheme();
        int i = 0;
        for (Color color : scheme.getWheelColors()) {
            this.WHEEL_AREAS[i].setColor(color);
            ++i;
        }
        i = 0;
        for (Color color : scheme.getPrimaryColors()) {
            this.PRIMARY_AREAS[i].setColor(color);
            ++i;
        }
        i = 0;
        for (Color color : scheme.getSecondaryColors()) {
            this.SECONDARY_AREAS[i].setColor(color);
            ++i;
        }
        i = 0;
        for (Color color : scheme.getExtraColors()) {
            this.EXTRA_AREAS[i].setColor(color);
            ++i;
        }
    }

    private void setNextColorScheme() {
        this.setColorScheme(this.getNextColorScheme());
    }

    public void onKeyDown(KeyEvent event) {
        this.setNextColorScheme();
    }

    public static void main(String[] args) {
        Game.start((Scene)new ColorWheelIttenDemo(), (int)520, (int)520);
    }
}

