/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Image;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import java.awt.Color;

public class BasketballThrowDemo
extends Scene {
    private static final int WIDTH = 1240;
    private static final int HEIGHT = 812;
    private final Ball ball;
    private final Rectangle basket;

    public BasketballThrowDemo() {
        this.setGravityOfEarth();
        this.getCamera().setMeter(100.0);
        Vector ballPosition = new Vector(-1.7, 0.5);
        Actor[] actorArray = new Actor[1];
        this.ball = new Ball(ballPosition.getX(), ballPosition.getY());
        actorArray[0] = this.ball;
        this.getMainLayer().add(actorArray);
        this.getMainLayer().add(new Actor[]{new Wall(-6.0, -4.5, 12.0, 1.0)});
        this.getMainLayer().add(new Actor[]{new Wall(-6.0, 3.5, 12.0, 1.0)});
        this.getMainLayer().add(new Actor[]{new Wall(-6.5, -4.5, 1.0, 9.0)});
        this.getMainLayer().add(new Actor[]{new Wall(5.5, -4.5, 1.0, 9.0)});
        BallShadow ballShadow = new BallShadow(ballPosition.getX(), ballPosition.getY());
        this.ball.createDistanceJoint((Actor)ballShadow, new Vector(0.15, 0.15), new Vector(0.15, 0.15));
        this.getMainLayer().add(new Actor[]{ballShadow});
        this.basket = new Rectangle(1.5, 0.05);
        this.basket.setColor(Color.RED);
        this.basket.setPosition(3.0, 0.5);
        this.basket.makeSensor();
        this.basket.setGravityScale(0.0);
        this.basket.addCollisionListener((Actor)this.ball, event -> this.defer(() -> this.basket.setX(-this.basket.getX())));
        this.getMainLayer().add(new Actor[]{this.basket});
        this.addKeyStrokeListener(e -> {
            if (e.getKeyCode() == 32) {
                this.ball.setVelocity(new Vector(Math.signum(this.basket.getX()) * 2.0, 6.0));
            }
        });
    }

    public static void main(String[] args) {
        Game.start((Scene)new BasketballThrowDemo(), (int)1240, (int)812);
    }

    private static class Ball
    extends Image {
        public Ball(double x, double y) {
            super("shots/ball.png", 0.3, 0.3);
            this.setPosition(x + 0.15, y + 0.15);
            this.setFixture(() -> FixtureBuilder.circle((double)0.15, (double)0.15, (double)0.15));
            this.makeDynamic();
            this.setElasticity(0.85);
            this.setFriction(0.1);
        }
    }

    private static class Wall
    extends Rectangle {
        public Wall(double x, double y, double width, double height) {
            super(width, height);
            this.setPosition(x, y);
            this.setColor(Color.WHITE);
            this.makeStatic();
            this.setFriction(0.05);
            this.setElasticity(0.3);
            this.setDensity(150.0);
        }
    }

    private static class BallShadow
    extends Image {
        public BallShadow(double x, double y) {
            super("shots/shadow.png", 0.3, 0.3);
            this.setPosition(x + 0.15, y + 0.15);
            this.setFixture(() -> FixtureBuilder.circle((double)0.15, (double)0.15, (double)0.15));
            this.makeSensor();
            this.setGravityScale(0.0);
            this.setRotationLocked(true);
        }
    }
}

