/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi_demos;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Animation;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.StatefulAnimation;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollEvent;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListener;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class MinimalDemo
extends Scene
implements KeyStrokeListener,
MouseScrollListener,
FrameUpdateListener {
    private static final int WIDTH = 1020;
    private static final int HEIGHT = 520;
    private final Rectangle rectangle = new Rectangle(50.0, 100.0);
    private final StatefulAnimation<String> character;

    public MinimalDemo() {
        this.rectangle.setColor(Color.BLUE);
        this.add(new Actor[]{this.rectangle});
        Animation animation = Animation.createFromAnimatedGif((String)"game-assets/jump/fx_explosion_b_anim.gif", (double)1.0, (double)1.0);
        animation.setPosition(200.0, 200.0);
        this.add(new Actor[]{animation});
        Text text = new Text("Hallo!", 2.0);
        text.setPosition(-100.0, -100.0);
        text.setColor(Color.MAGENTA);
        this.add(new Actor[]{text});
        this.character = new StatefulAnimation(64.0, 64.0);
        String pathbase = "game-assets/dude/char/spr_m_traveler_";
        Animation idle = Animation.createFromAnimatedGif((String)"game-assets/dude/char/spr_m_traveler_idle_anim.gif", (double)1.0, (double)1.0);
        this.character.addState((Object)"idle", idle);
        this.character.addState((Object)"walking", Animation.createFromAnimatedGif((String)"game-assets/dude/char/spr_m_traveler_walk_anim.gif", (double)1.0, (double)1.0));
        this.character.addState((Object)"running", Animation.createFromAnimatedGif((String)"game-assets/dude/char/spr_m_traveler_run_anim.gif", (double)1.0, (double)1.0));
        this.character.addState((Object)"jumpingUp", Animation.createFromAnimatedGif((String)"game-assets/dude/char/spr_m_traveler_jump_1up_anim.gif", (double)1.0, (double)1.0));
        this.character.addState((Object)"midair", Animation.createFromAnimatedGif((String)"game-assets/dude/char/spr_m_traveler_jump_2midair_anim.gif", (double)1.0, (double)1.0));
        this.character.addState((Object)"falling", Animation.createFromAnimatedGif((String)"game-assets/dude/char/spr_m_traveler_jump_3down_anim.gif", (double)1.0, (double)1.0));
        this.character.addState((Object)"landing", Animation.createFromAnimatedGif((String)"game-assets/dude/char/spr_m_traveler_jump_4land_anim.gif", (double)1.0, (double)1.0));
        this.character.setStateTransition((Object)"landing", (Object)"idle");
        this.add(new Actor[]{this.character});
    }

    public void onKeyDown(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 39: {
                this.rectangle.moveBy(50.0, 0.0);
                break;
            }
            case 37: {
                this.rectangle.moveBy(-50.0, 0.0);
                break;
            }
            case 67: {
                this.character.setState((Object)"midair");
            }
        }
    }

    public void onMouseScrollMove(MouseScrollEvent event) {
        double newZoom = this.getCamera().getMeter() + event.getPreciseWheelRotation() * -0.2;
        if (newZoom > 0.0) {
            this.getCamera().setMeter(newZoom);
        }
    }

    public void onFrameUpdate(double pastTime) {
        float camSpeed = 600.0f;
        if (Game.isKeyPressed((int)87)) {
            this.getCamera().moveBy(0.0, (double)camSpeed * pastTime);
        }
        if (Game.isKeyPressed((int)83)) {
            this.getCamera().moveBy(0.0, (double)(-camSpeed) * pastTime);
        }
        if (Game.isKeyPressed((int)65)) {
            this.getCamera().moveBy((double)(-camSpeed) * pastTime, 0.0);
        }
        if (Game.isKeyPressed((int)68)) {
            this.getCamera().moveBy((double)camSpeed * pastTime, 0.0);
        }
    }

    public static void main(String[] args) {
        Game.debug();
        Game.start((Scene)new MinimalDemo(), (int)1020, (int)520);
        Game.setTitle((String)"Minimale Demo");
    }
}

